/*
  routes4david.c
  to convert a danny routes file to form usable by david
  finucane@myri.com
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "mt_Component.h"
#include "mt_MapFile.h"
#include "mt_Graph.h"
#include "mt_Calculator.h"
#include "mt_Args.h"
#include "mt_RouteTable.h"
#include "mt_Host.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)


static const char*DELIMITERS = "(), *\n\r\t";
static const char*COMMENT_CHARS = "#;\n";
#define MAX_LINE 300

static void printLine (char*s)
{
  printf ("%s\n", s);
}

static int parseRoute (char*line, mt_Node*h, mt_Graph*g, char*name, mt_Route*r)
{
  char hops [mt_Route::MAX_ROUTE];
  int numHops = 0;
  
  insist (line && h && g && name && r);
 
  mt_Token*tokens;
  tokens = new mt_Token (line, DELIMITERS);
  insistp (tokens, ("couldn't allocate tokens"));
  
  int in;
  in = h->getOpposite (0);
  
  if (!tokens->getNext () || !tokens->getNext ())
  {
    mt_Component::printFormat ("expected two useless tokens at the start of the line.");
    return 0;
  }
   
  while (tokens->getNext ())
  {
    if (tokens->isInteger ())
    {
      mt_Component::printFormat ("expected from node name");
      return 0;
    }
    
    char*s = tokens->getWord ();
    insist (s);
    
    strncpy (name, s, mt_Host::NAME_LENGTH);
    
    mt_Node*n = g->getNode (s);
    if (!n)
    {
      mt_Component::printFormat ("%s is not a node in the map file", s);
      return 0;
    }

    if (!tokens->getNext ())
    {
      if (!n->isHost () || !r->fromBytes (hops, numHops))
	return 0;
      if (h->getNode (r) != n)
      {
	mt_Component::printFormat ("route %s does not lead from %s to %s\n",
		     r->toString (), h, n);
	return 0;
      }
      return 1;
    }

    if (!tokens->isInteger ())
    {
      mt_Component::printFormat ("expected port number");
      break;
    }
    
    int p = tokens->getInteger ();
  
    hops [numHops++] = p - in;
    in = n->getOpposite (p);
  }
  exception: return 0;
}

int main (int argc, char*argv [])
{
  mt_Component::initialize (printLine);
  mt_Route route;
  FILE*fp = stdout;
  
  if (argc != 3)
    die (("usage: %s <mapfile> <dannyroutefile>", argv [0]));
  
  char*mapFile = argv[1];
  char*routesFile = argv[2];
  
  mt_MapFile mf (mapFile, mt_File::_READ);
  mt_Graph g;

  if (!mf.read (&g))
    die (("main: couldn't parse map file %s", mapFile));

  int numHosts = g.getNumHosts ();
  insist (numHosts > 0);

  mt_FileReader*reader;
  reader = new mt_FileReader (routesFile, MAX_LINE, COMMENT_CHARS);
  insistp (reader, ("couldn't alloc file reader"));

  char*line;
  int hostsSeen;
  hostsSeen = 0;

  if (!mt_RouteFile::writeLimits (fp, numHosts, 1))
    return 0;

  while ((line = reader->readLine ()))
  {
    if (*line == '\n')
      continue;
    
    mt_Token*tokens = new mt_Token (line, DELIMITERS);
    insistp (tokens, ("couldn't allocate tokens"));

    if (!tokens->getNext () || tokens->isInteger ())
    {
      mt_Component::printFormat ("expected from host name");
      break;
    }
    
    char*name = tokens->getWord ();
    insist (name);
    
    mt_Node*h = g.getNode (name);
    if (!h || !h->isHost ())
    {
      mt_Component::printFormat ("%s is not a host in map file %s", name, mapFile);
      break;
    }
    
    if (!tokens->getNext () || !tokens->isInteger ())
    {
      mt_Component::printFormat ("expected host count");
      break;
    }
    
    int numLines = tokens->getInteger ();
    if (numLines != numHosts)
    {
      mt_Component::printFormat ("%s does not equal the number of hosts in map file %d",
		   tokens->getWord (), numHosts);
      break;
    }

    if (!mt_RouteFile::writeFromLine (fp, name, numHosts, mt_Route::MAX_ROUTE * numHosts))
      break;
    
    int i;
    for (i = 0; i < numLines; i++)
    {
      if (!(line = reader->readLine ()))
      {
	mt_Component::printFormat ("unexpected end of file");
	break;
      }

      char dn [mt_Node::NAME_LENGTH + 1];
      
      mt_Route r;
      if (!parseRoute (line, h, &g, dn, &r))
	break;
    
      if (!mt_RouteFile::writeToLine (fp, dn, &r))
	break;
    }
    if (i != numLines)
      break; 
    hostsSeen++;
  }

  if (hostsSeen != numHosts)
  {
    mt_Component::printFormat ("%d sets of routes seen, %d expected", hostsSeen, numHosts);
  }

  if (reader->readLine ())
  {
    mt_Component::printFormat ("line: %d. Syntax error.", reader->getLineNumber ());
    return 0;
  }
  return 1;
  exception: return 0;
}
