#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "mt_Component.h"
#include "mt_MapFile.h"
#include "mt_Graph.h"
#include "mt_Calculator.h"
#include "mt_Args.h"
#include "mt_RouteTable.h"


#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)


static void printLine (char*s)
{
  printf ("%s\n", s);
}

mt_Node*getHost (mt_Graph*g, char*shortName)
{
  insist (g && shortName);
  
  for (int i = 0; i < g->getNumHosts (); i++)
  {
    if (strstr (g->getHost (i)->getName (), shortName))
      return g->getHost (i);
  }
  exception: return 0;
}

int main (int argc, char*argv[])
{
  mt_Component::initialize (printLine);

  if (argc != 3)
    die (("usage: %s <mapfile> <nway-outputfile>\n", argv[0]));
  
  char*mapFile = argv [1];
  char*errorFile = argv[2];
  mt_FileReader*reader = new mt_FileReader (errorFile, 255, "#;");
  char*line;
  char buffer [255];
  
  mt_MapFile mf (mapFile, mt_File::_READ);
  mt_Graph g;

  if (!mf.read (&g))
    die (("main: couldn't parse map file %s", mapFile));

  insist (reader);
  
  while ((line = reader->readLine ()))
  {
    char*s,*t;
    
    if (!strstr (line, "sender") || !strstr (line, ":"))
      continue;
  
    strcpy (buffer, line);
    
    s = strstr (buffer, ":");
    insist (s);
    
    *s = 0;
    
    mt_Node*n1,*n2;
    n1 = getHost (&g, buffer);
    insist (n1);    

    strcpy (buffer, line);
    
    s = strstr (buffer, "sender");
    insist (s);
    
    s += strlen ("sender");
    t = strstr (s, ",");
    insist (t);
    *t = 0;
    
    n2 = g.getGmId (atoi (s));
    insist (n2);
    
    printf ("%d %d\n", n1->getGmId (), n2->getGmId ());
  }
  exception: return 0;
}



