/*
  longest.c
  returns longest route
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "mt_MapFile.h"
#include "mt_RouteTable.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)


static void printLine (char*s)
{
  printf ("%s\n", s);
}

int main (int argc, char*argv[])
{  
  mt_Component::initialize (printLine);
    
  mt_RouteTable routes;
  mt_Graph graph;
  
  if (argc != 3)
    die (("usage: %s <mapfile> <routefile>\n", argv[0]));
 
  char*mapFile = argv [1];
  char*routeFile = argv[2];

  mt_MapFile mf (mapFile, mt_File::_READ);
  
  if (!mf.read (&graph))
    die (("main: couldn't parse map file %s", mapFile));
  
  if (!routes.fromFile (routeFile, &graph))
    die (("main: couldn't read %s", routeFile));

  int longest, longi, longj, longk;
  longest = longi = longj = longk = 0;
  int numHosts = graph.getNumHosts ();
  
  for (int i = 0; i < numHosts; i++)
  {
    for (int j = 0; j < numHosts; j++)
    {
      int numRoutes = routes.getNumRoutes (i, j);
      for (int k = 0; k < numRoutes; k++)
      {
	mt_Route r;
	if (!routes.getRoute (i, j, k, &r))
	  die (("main: couldn't get route %d, %d, %d", i, j, k));
	
	if (r.getLength () > longest)
	{
	  longest = r.getLength ();
	  longi = i;
	  longj = j;
	  longk = k;
	}
      }
    }
  }
  
  mt_Component::printFormat ("longest route is route %d from %s to %s, %d hops", 
			     longk,
			     graph.getHost (longi)->getName (),
			     graph.getHost (longj)->getName (),
			     longest);
  return 0;
}
