/*
  deadlock.c
  deadlock detecting program
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "mt_Component.h"
#include "mt_MapFile.h"
#include "mt_Graph.h"
#include "mt_Calculator.h"
#include "mt_Args.h"
#include "fc_Calculator.h"
#include "de_Deadlock.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)


static void printLine (char*s)
{
  printf ("%s\n", s);
}

int main (int argc, char*argv[])
{
  int deadlockable;
  mt_Calculator*calculator;
  
  mt_Component::initialize (printLine);
  
  mt_Args args (mt_Args::CALCULATOR, 2);

  if (argc != 3)
    die (("usage: %s <mapfile> <routefile>\n", argv[0]));
 
  char*mapFile = argv [1];
  char*routeFile = argv[2];

  mt_MapFile mf (mapFile, mt_File::_READ);

  de_Deadlock deadlock;
  
  if (!mf.read (&deadlock))
    die (("main: couldn't parse map file %s", mapFile));
  
  args.addArg ("-routes-file");
  args.addArg (routeFile);
  
  if (!(calculator = mt_getCalculator ()))
    die (("mt_getCalculator failed"));
  
  if (!calculator->parseArgs (&args) || !calculator->initialize (&deadlock, 0))
    die (("main: couldn't initialize calculator"));

  deadlockable = deadlock.deadlockable (calculator);
  
  calculator->cleanup ();
  
  mt_Component::printFormat ("can%s deadlock", deadlockable ? "" : "not");

  if (deadlockable)
  {
    mt_Component::printFormat ("on the following cycle:");
    deadlock.print ();
  }
  return 0;
}



