
#include <stdlib.h>
#include <stdio.h>
#include "gm.h"
#include "gm_internal.h"

#define die(s){printf s; printf ("\n"); exit (1);}
#define MAX_SENDS 40
#define MTU 4000


static void send (struct gm_port*port, char*p, int length)
{
  *p = 0;
  _gm_raw_send (port, p, length, 1);
}

static void receive (struct gm_port*port, int*pendingSends)
{
  gm_recv_event_t*event;
  event = gm_blocking_receive_no_spin (port);

  switch (GM_RECV_EVENT_TYPE (event))
  {
    case GM_SENT_EVENT:
      (*pendingSends)--;
      return;
    case GM_RAW_RECV_EVENT:
      return;
    case GM_FAST_RECV_EVENT:
    case GM_FAST_HIGH_RECV_EVENT:
    case GM_FAST_PEER_RECV_EVENT:
    case GM_FAST_HIGH_PEER_RECV_EVENT:
      return;
    case GM_RECV_EVENT:
    case GM_HIGH_RECV_EVENT:
    case GM_PEER_RECV_EVENT:
    case GM_HIGH_PEER_RECV_EVENT:
      return;
    case GM_NO_RECV_EVENT:
      return;
    case GM_ALARM_EVENT:
      gm_unknown (port, event);
    default:
      gm_unknown (port, event);
      return;
  }
}


int main (int argc, char*argv [])
{
  struct gm_port*port;
  int unit, count, size;
  char*sends [MAX_SENDS];
  int i;
  gm_s64_t start, stop;
  double td;
  int pendingSends, numSends;

  if (argc != 5)
    die (("usage %s <unit> <buffers> <count> <size>", argv [0]));

  unit = atoi (argv [1]);
  numSends = atoi (argv [2]);
  count = atoi (argv [3]);
  size = atoi (argv [4]);

  if (size > MTU)
    die (("size %d is greater than MTU %d", size, MTU));

  if (numSends <= 0 || numSends > MAX_SENDS)
    die (("buffers %d is 0 or  greater than max sends %d", numSends, MAX_SENDS));
  
  if (_gm_mapper_open (&port, unit, GM_API_VERSION_1_0) != GM_SUCCESS)
    die (("couldn't open mapper port on unit %d", unit));

  for (i = 0; i < numSends; i++)
    if (!(sends [i] = (char*) gm_dma_malloc (port, MTU)))
      die (("gm_dma_malloc failed"));
  
  start = gm_ticks (port);
  
  pendingSends = 0;
  for (i = 0; i < count; i++)
  {
    while (pendingSends == numSends)
      receive (port, &pendingSends);
    send (port, sends [i % numSends], size);
    pendingSends++;
  }

  stop = gm_ticks (port);

  td = (double) stop - (double) start;
  
  if (td)
    printf ("%5.2f (mbps)\n", 8.0 * ((double) size * (double) count) / (td/2));  
  return 0;
}
