/*
  bandwidth.c
  blast messages through mapper port
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <stdlib.h>

#include "mt_Network.h"
#include "mt_Host.h"

#include "insist.h"

static void printLine (char*s)
{
  printf ("%s\n", s);
  fflush (stdout);
}

class ba_Bandwidth : public mt_Job
{
  private:
  int size;
  int count;
  int unit;
  
  public:
  int parseArgs (int argc, char*argv []);
  void usage ();
  ba_Bandwidth (mt_Node*node, mt_Network*network);
  
  virtual void dump (FILE*fp);
  virtual int willWait ();
  virtual int start ();
  virtual void receive (int event, char*p, int length);
};


ba_Bandwidth::ba_Bandwidth (mt_Node*node, mt_Network*network) : mt_Job (node, network)
{
}

int ba_Bandwidth::parseArgs (int argc, char*argv [])
{
  if (argc != 4)
    return 0;
  
  unit = atoi (argv [1]);
  
  if (!(count = atoi (argv [2])))
    return 0;

  if (!(size = atoi (argv [3])))
    return 0;  

  insistp (unit >= 0 && unit < 16, ("bad unit number %s", argv [1]));
  insistp (count >= 0, ("bad count %s", argv [2]));
  insistp (size > 0 && size <= 4000, ("bad size %s", argv [3]));
  
  return 1;
  exception: return 0;
}

void ba_Bandwidth::usage ()
{
  printFormat ("usage: <unit> <count> <size>");
}

void ba_Bandwidth::dump (FILE*fp)
{
}

int ba_Bandwidth::willWait ()
{
  return 1;
}


int ba_Bandwidth::start () 
{
  mt_Route a;
  mt_Route route (-14, &a);
  mt_Network*network = getNetwork ();
  mt_Address address;
  char name [mt_Network::HOSTNAME_LENGTH + 1];
  int type;
  mt_Int64 start, stop;

  if (!network->open (this, &address, name, &type, unit))
    return 0;
  
  start = network->getCurrentTime ();
  
  char*message = (char*) malloc (size);
  insistp (message, ("alloc failed"));

  for (int i = 0; i < count; i++)
  {
    while (!network->isAborted () && !network->send (this, &route, message, size))
    {
      char*p;
      int length;

      if (network->wait (&p, &length) != mt_Network::SEND_DONE)
      {
	printFormat (("error in sending: didn't get a expected send done"));
	return 0;
      }
    }
  }
  stop = network->getCurrentTime ();
  network->close (this);
  free (message);
  
  double td;
  td = (double) stop - (double) start;
  
  if (td)
    printFormat ("%5.2f (mbps)", 8.0 * ((double) size * (double) count) / (td/2));
  exception: return 0;
}

void ba_Bandwidth::receive (int event, char*p, int length)
{
}

int main (int argc, char*argv [])
{
  mt_Component::initialize (printLine);
  mt_Host host ("fake", "-");
  
  ba_Bandwidth*b = new ba_Bandwidth (&host, mt_getNetwork ());

  if (!b->parseArgs (argc, argv))
    b->usage ();
  else
    b->start ();
  return 0;
}

