#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mt_MapFile.h"
#include "sw_Test162.h"
#include "sw_Sender.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define call(e)   t++; r += e; if (lazy && t != r) goto the_end

static void printLine (char*s)
{
  printf ("%s\n", s);
}

int main (int argc, char*argv [])
{
  mt_Component::initialize (printLine);
  char*mapFile = argv [2];
  char*hostname = argv [3];
  char*switchname = argv [4];
  char*switchmapname = argv [5];
  char*lazyname = argv [6];
  char*lanainame = argv [7];
  
  mt_Node*h;
  mt_Node*s;
  int unit;
  int lazy;
  int lanai;

  if (argc < 7) die (("usage: %s <unit> <map file> <host> <switchname> <switch-map-name> tries <lazy | eager> <lanai>", argv [0]));

  mt_MapFile mf (mapFile, mt_File::_READ);
  mt_Graph graph;
  
  unit = atoi (argv [1]);
  
  if (!mf.read (&graph))
    die (("couldn't parse map file %s", mapFile));

  if (!(h = graph.getNode (hostname)) || !h->isHost ())
    die (("%s is not a host in map file %s", hostname, mapFile));
  
  if (!(s = graph.getNode (switchmapname)) || !s->isSwitch ())
    die (("%s is not a switch in map file %s", switchmapname, mapFile));
  
  if (strcmp (lazyname, "lazy") && strcmp (lazyname, "eager"))
    die (("%s is neither lazy nor eager ", lazyname));

  lazy = !strcmp (lazyname, "lazy");
  lanai = atoi (lanainame);
  
  sw_TestPort port (switchname);  
  sw_Test162 test (unit, &graph, mt_getNetwork(), h, &port, 1, &s, 1, lazy, lanai);
  int xbar = 0;

  int r,t;
  r = t = 0;  

  test.initialize (xbar);
  port.setBClock (xbar, 118);
  
  port.disableUpdate (xbar);
  port.disableImpedence (xbar);
  port.setRelays (xbar, 0xffff);
  port.resetXbar (xbar);

  
  call (test.testBandwidth (xbar));

  call (test.testId (xbar));
  call (test.testAuto1 (xbar));
  call (test.testGlobalControl (xbar));

  port.resetXbar (xbar);
  port.setGlobalControl (xbar, 0xfd);

  call (test.testImpedence (xbar));
  call (test.testAutoImpedence (xbar));
  call (test.testSpeed (xbar));
  call (test.testAuto2 (xbar));

  
  int tc;
  tc = 0;

  call (test.testMessage (xbar));

  call (test.testCrosspoints (xbar));
  call (test.testCounters ());

  test.enableCrc ();  

  call (test.testAuto3 (xbar));
  call (test.testIllegal (xbar));


  call (test.testInvalidHeads (xbar));
  call (test.testTimeouts (xbar));
  call (test.testPortOnOff (xbar));

  call (test.testAuto4 (xbar));
  call (test.testAuto5 (xbar));
  port.setBClock (xbar, 10);

  call (test.testAuto6 (xbar));

  port.enableUpdate (xbar);
  
  the_end:

  mt_Component::printFormat ("%d / %d received in all", sw_Sender::getTotalReceived (), sw_Sender::getTotalSent ());  

  test.printResult (t == r);
  
  if (!test.printBadCounters (xbar))
    mt_Component::printFormat ("there were some bad counters");
  
  return 0;
}
