#ifndef test_h
#define test_h

#include "hardware.h"

#define TEST_MTU 1024

typedef struct test_message_t
{
  int type;
  int xbar;
}test_message_t;

typedef struct chip_id_message_t
{
  int type;
  char pad[2];
  hw_chip_id data;
}chip_id_message_t;

typedef struct impedence_test_message_t
{
  int type;
  int xbar;
  hw_impedence_test data;
}impedence_test_message_t;

typedef struct impedence_message_t
{
  int type;
  int xbar;
  hw_impedence data;
}impedence_message_t;

typedef struct impedence2_message_t
{
  int type;
  int xbar;
  hw2_impedence data;
}impedence2_message_t;

typedef struct packet_counter_message_t
{
  int type;
  int xbar;
  hw_packet_counter data;
}packet_counter_message_t;

typedef struct packet_counters_message_t
{
  int type;
  int xbar;
  hw_packet_counters data;
}packet_counters_message_t;


typedef struct link_status_message_t
{
  int type;
  int xbar;
  hw_link_status data;
}link_status_message_t;

typedef struct control_message_t
{
  int type;
  int xbar;
  hw_control data;
}control_message_t;

typedef struct global_control_message_t
{
  int type;
  int xbar;
  char pad[3];
  hw_global_control data;
}global_control_message_t;

typedef struct speed_message_t
{ int type;
  int xbar;
  hw2_speed data;
}speed_message_t;

typedef struct a2d_message_t
{
  int type;
  int xbar;
  int data;
}a2d_message_t;

typedef struct set_relays_message_t
{
  int type;
  int xbar;
  int data;
} set_relays_message_t;

typedef struct access_uc_message_t
{ 
  int type;
  int port;
  int txlen;
  int rxlen;
  unsigned char data[96];
} access_uc_message_t;

typedef struct write_ics_message_t
{
  int type;
  int val;
} write_ics_message_t;

typedef struct test2_change_bclk_t
{
  int type;
  int val;
} test2_change_bclk_t;

typedef struct kill_port_message_t
{
  int type;
  int xbar;
  int port;
}kill_port_message_t;

typedef struct get_int_message_t
{
  int type;
  int xbar;
  int value;
}get_int_message_t;

typedef struct set_port_control_message_t
{
  int type;
  int xbar;
  int port;
  int control;
} set_port_control_message_t;

typedef struct set_timeout_message_t
{
  int type;
  int xbar;
  int usecs;
} set_timeout_message_t;

typedef struct port_state_message_t
{
  int type;
  int xbar;
  int port;
  int uptime;
  int good_low;
  int good_high;
  int bad_low;
  int bad_high;
  int timeouts;
  int illegal_symbols;
  int missed_beats;
  int bad_routes;
  int dead_routes;
  int port_state;
  int control;
} port_state_message_t;

#define GET_VERSION_STRING_LENGTH 200
typedef struct version_string_message_t
{
  int type;
  char version [GET_VERSION_STRING_LENGTH + 1];
}version_string_message_t;

#define TEST_STRING "Tamburlaine, the scourge of God must die."

enum
{
  TEST_READ_CHIP = 0,
  TEST_READ_IMPEDENCE_TEST,
  TEST_READ_IMPEDENCE,
  TEST_WRITE_IMPEDENCE_TEST,
  TEST_WRITE_IMPEDENCE,
  TEST_READ_PACKET_COUNTERS,
  TEST_READ_LINK_STATUS,
  TEST_READ_CONTROL,
  TEST_WRITE_CONTROL,
  TEST_READ_GLOBAL_CONTROL,
  TEST_WRITE_GLOBAL_CONTROL,
  TEST_ENABLE_XBAR_UPDATE,
  TEST_DISABLE_XBAR_UPDATE,
  TEST_ENABLE_XBAR_IMP_UPDATE,
  TEST_DISABLE_XBAR_IMP_UPDATE,
  TEST_RESET_XBAR,
  TEST_READ_A2D,
  TEST_SET_RELAYS,
  TEST_ACCESS_UC,
  TEST_WRITE_ICS,
  TEST_KILL_PORT,
  TEST_TURN_ON_BEAT_SHUTDOWN,
  TEST_TURN_OFF_BEAT_SHUTDOWN,
  TEST_GET_VERSION_STRING,
  TEST_REBOOT, 
  TEST_CAUSE_FAULT,
  TEST_GET_UPTIME,
  TEST_GET_EXTENDED_COUNT,
  TEST_GET_EXTENDED_VALUE,
  TEST_SET_PORT_CONTROL,
  TEST_SET_TIMEOUT,
  TEST_GET_TIMEOUT,
  TEST_GET_PORT_STATE,
  TEST_CLEAR_COUNTERS,

  TEST_GET_SWITCH_TEMP,
  TEST_GET_PRODUCT_TYPE,
  TEST_GET_PORT_STATES,
  TEST_GET_SELF_TEST_RESULT,
  TEST_GET_SWITCH_IS_ON,

  TEST_TURN_HA_ON,
  TEST_TURN_HA_OFF,
  TEST_TURN_AUTO_ON,
  TEST_TURN_AUTO_OFF,

  TEST_READ_SPEED,
  TEST_WRITE_SPEED,
  TEST2_READ_IMPEDENCE,
  TEST2_WRITE_IMPEDENCE,

  TEST2_CHANGE_BCLK,
  TEST_NUM_COMMANDS /*leave at end*/
};
     

#endif /*test_h*/
