/*
  sw_Threadable.h
  thread hook.
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#include "mt_Component.h"
#include "sw_Threadable.h"
#include "insist.h"


/* extern "C" void*sw_ThreadableCreateHook (void*p); */

static void*sw_ThreadableCreateHook (void*p)
{
  sw_Threadable*threadable = (sw_Threadable*)p;
  return (void*) threadable->startThread ();
}

sw_Threadable::sw_Threadable ()
{
  state = CREATED;
}

int sw_Threadable::isStopped ()
{
  insistf (this);
  return state == STOPPED;
  exception: return 0;
}

int sw_Threadable::createThread ()
{
  insistf (this);

  if (state == RUNNING)
    return 1;

  state = RUNNING;

  thread = (pthread_t*) malloc (sizeof (pthread_t));
  insistf (thread);
  
  pthread_create ((pthread_t*)thread, 0, sw_ThreadableCreateHook, (void*) this);

  return 1;
  exception: return 0;
}

int sw_Threadable::stopThread ()
{
  void*r;

  state = STOPPED;
  pthread_join (*((pthread_t*)thread), &r);
  return (int) r;
}
