/*
  sw_Test162.h
  class to test a 16 port switch
  finucane@myri.com (David Finucane)
*/

#include "sw_Test16.h"

class sw_Test162 : public sw_Test16
{
  protected:
  int testAuto1 (int xbar, int en, int ha);
  int testSpeed (int xbar, int port, int set);
  int verifyAuto (int xbar, int en, int ha);
  virtual int getIllegalSymbols (int xbar, int port);
  virtual int getStatusUpdate (int xbar, int port);
  virtual int getPortShutdown (int xbar, int port);
  virtual int getInvalidHeads (int xbar, int port);
  virtual int getTimeout (int xbar, int port, int set);
  
  public:
  sw_Test162 (int unit, mt_Graph*graph, mt_Network*network, mt_Node*host, sw_TestPort*port, int numSwitches, mt_Node**switches, int verbose, int lazy, int lanai);
  virtual int testOutputImpedence (int xbar, char vlow, char vhigh, char, char);
  virtual int testInitialOutputImpedence (int xbar);
  int testId (int xbar);
  int testImpedence (int xbar);
  int testGlobalControl (int xbar);
  int testAuto1 (int xbar);
  int testAutoImpedence (int xbar);
  int testSpeed (int xbar);
  int testAuto2 (int xbar);
  int testMessage (int xbar);
  int testAuto3 (int xbar);
  int testAuto4 (int xbar);
  int testAuto5 (int xbar);
  int testAuto6 (int xbar);  
  int testTimeout (int xbar, int port, int globalControl, double min, double max);
  int initialize (int xbar);
};
