/*
  sw_RouteSender.c
  "port sender"
  finucane@myri.com (David Finucane)
*/

#include "sw_RouteSender.h"
#include "insist.h"

sw_RouteSender::sw_RouteSender (mt_Job*job, mt_Network*network, mt_Graph*graph, int receiveWait, int sendWait, int length, int count) : sw_Sender (job, network, graph, receiveWait, sendWait)
{
  insist (this);
  
  this->length = length;
  this->count = count;

  exception:;
}

int sw_RouteSender::setRoute (mt_Route*route)
{
  insist (this);
  insist (route);
  this->route = *route;
  return 1;
  exception: return 0;
}

int sw_RouteSender::startThread ()
{
  insist (this);
  insist (length > 0 && length <= mt_Network::MTU);
  insist (count >= 0);
  
  if (!sw_Sender::startThread ())
    return 0; 
    
  for (int i = 0; i < count; i++)
  {
    mt_ProbeMessage m (0, i);
    m.swap ();

    if (!sendProbe (&route, &m, length))
    {
      printFormat ("sendProbe failed");
      return 0;    
    }
  }

  if (receiveWait)
    waitForReceives ();
  
  return !receiveWait || getNumSent () == getNumReceived ();
  exception: return 0;
}

