/*
  sw_MessageSender.h
  "message test"
  finucane@myri.com (David Finucane)
*/

#include "sw_MessageSender.h"
#include "insist.h"

sw_MessageSender::sw_MessageSender (mt_Job*job, mt_Network*network, mt_Graph*graph, mt_Node*_switch, int receiveWait, int sendWait, int length, int count) : sw_Sender (job, network, graph, receiveWait, sendWait)
{
  this->length = length;
  this->_switch = _switch;
  this->count = count;
}

int sw_MessageSender::startThread ()
{
  insist (this);
  insist (length > 0 && length <= mt_Network::MTU);

  if (!sw_Sender::startThread ())
    return 0;
 
  graph->computeRoutes (job->getNode ());
  
  int maxNodes;
  maxNodes = _switch->getMaxNodes ();

  while (!isStopped () && (!count || getNumSent () < count))
  {
    for (int i = 0; i < maxNodes; i++)
    {
      mt_Route r;
      
      if (!getSwitchRoute (&r, _switch, i))
	continue;
      
      mt_ProbeMessage m (0, i);
      m.swap ();

      counts [i]++;
      if (i == _switch->getIn ())
	counts [_switch->getIn ()]++;

      if (!sendProbe (&r, &m, length))
      {
	printFormat ("sendProbe failed");
	return 0;    
      }
    }
  }  

  if (receiveWait)
    waitForReceives ();
  
  return !receiveWait || getNumSent () == getNumReceived ();
  exception: return 0;
}
