/*
  sw_CrossPointSender.h
  "crosspoint test"
  finucane@myri.com (David Finucane)
*/

#include <stdlib.h>
#include <string.h>

#include "de_Deadlock.h"
#include "sw_CrossPointSender.h"
#include "insist.h"

sw_CrossPointSender::sw_CrossPointSender (mt_Job*job, mt_Network*network, mt_Graph*graph, mt_Node*_switch, int minSize, int maxSize, int incrementSize, int count) : sw_Sender (job, network, graph, 1, 0)
{
  this->_switch = _switch;
  this->count = count;
  this->minSize = minSize;
  this->maxSize = maxSize;
  this->incrementSize = incrementSize;
}

int sw_CrossPointSender::startThread ()
{
  int phase = 0;
  de_Deadlock deadlock;
  
  insist (this);

  memset (sent, 0, sizeof (sent));
  memset (received, 0, sizeof (received));
  
  if (!sw_Sender::startThread ())
    return 0;

  mt_Node*host;
  host = job->getNode ();
  
  graph->computeRoutes (host);
  
  if (!deadlock.clone (graph))
    return 0;
  
  int maxNodes;
  maxNodes = _switch->getMaxNodes ();

  for (int j = 0; j < maxNodes; j++)
  {
    mt_Node*jn = _switch->getNode (j);
    if (!jn || !jn->isSwitch ())
      continue;

    for (int k = 0; k < maxNodes; k++)
    {
      int length;
      
      mt_Node*kn = _switch->getNode (k);
      if (!kn || !kn->isSwitch ())
	continue;
	  
      mt_ProbeMessage m (0, phase++);
      m.swap ();
      length = sizeof (mt_ProbeMessage);

      mt_Route a (jn->getRoute (0), _switch->getOpposite (j) - jn->getIn ());

      mt_Node*fn;
      int fin;
      insist (host->follow (&a,  &fn, &fin) && fn == _switch);

      mt_Route b (&a,  k - j);

      insist (host->follow (&b,  &fn, &fin) && fn == kn);

      mt_Route c;
	  
      if (kn != _switch)
      {
	mt_Route t;
	mt_Route d (&t, 0);
	c = d;
      }
      mt_Route e (*_switch->getRoute (0));
      e.invert ();
      mt_Route f (&b, &c);
      mt_Route g (&f, _switch->getIn () - k, &e);

      if (deadlock.deadlockable (&g, host->getTypeIndex (), host->getTypeIndex ()))
	continue;

      for (int size = minSize; size <= maxSize; size += incrementSize)
      {
	for (int cc = 0; cc < count; cc++)
	{
	  sent [j][k]++;
	  if (sendProbe (&g, &m, size > length ? size : length))
	    received [j] [k]++;
	}
      }
    }
  }

  waitForReceives ();

  return getNumSent () == getNumReceived ();
  exception: return 0;
}

int sw_CrossPointSender::printGrid ()
{
  insist (this);
  insist (job->getNode () && _switch);
  
  printFormat ("switch %s:", _switch->getName ());
  printFormat ("the route from %s to %s is %s", job->getNode ()->getName (), _switch->getName(), _switch->getRoute (0)->toString ());

  for (int i = 0; i < mt_Switch::NUM_PORTS; i++)
  {
    char*line = buffer;
    line += sprintf (line, "%2.2d   ", i);
    
    for (int j = 0; j < mt_Switch::NUM_PORTS; j++)
    {
      if (sent [i] [j])
      {
	if (!received [i][j])
	  line += sprintf (line, "%s", "0 ");
	else if (sent [i] [j] != received [i][j])
	  line += sprintf (line, "%s", "$ ");
	else
	  line += sprintf (line, "%s", "1 ");
      }
      else line += sprintf (line, "%s", ". ");
    }
    printFormat ("%s", buffer);
  }
  return 1;
  exception: return 0;
}
