/*
  sw_BandwidthSender.h
  "message test"
  finucane@myri.com (David Finucane)
*/

#include "sw_BandwidthSender.h"
#include "insist.h"

sw_BandwidthSender::sw_BandwidthSender (mt_Job*job,  mt_Network*network, mt_Graph*graph, mt_Node*_switch, int numPackets, int port) : sw_Sender (job, network, graph, 0, 0)
{
  this->_switch = _switch;
  this->port = port;
  this->numPackets = numPackets;
  bandwidth = 0;
}

int sw_BandwidthSender::startThread ()
{
  insist (this);

  if (!sw_Sender::startThread ())
    return 0;
 
  graph->computeRoutes (job->getNode ());
  
  int maxNodes;
  maxNodes = _switch->getMaxNodes ();

  mt_Int64 start, stop;
  start = network->getCurrentTime ();  

  for (int i = 0; i < maxNodes; i++)
  {
    mt_Route r;
    if (port != -1 && port != i || !getPortRoute (&r, _switch, i))
      continue;

    mt_Node*fn;
    int fin;

    insist (!job->getNode ()->follow (&r, &fn, &fin) || fn != job->getNode ());
     
    for (int j = 0; j < numPackets; j++)
    { 
      mt_ProbeMessage m (0, i);
      m.swap ();

      // printFormat ("sending to route %s", r.toString ());

      if (!sendProbe (&r, &m, mt_Network::MTU))
      {
	printFormat ("sendProbe failed");
	return 0;    
      }
    }
  }  
  stop = network->getCurrentTime ();
  
  double td;
  td = (double) stop - (double) start;

  if ( td)
    bandwidth = 8.0 * ((double) mt_Network::MTU * (double) getNumSent ()) / (td/2);
  
  return 1;
  exception: return 0;
}

double sw_BandwidthSender::getBandwidth ()
{
  insist (this);
  return bandwidth;
  exception: return 0;
}
