#ifndef mx_defines_h
#define mx_defines_h

#define MX_FLASH_PORT 4001
#define MX_TEST_PORT 4002

#define MX_FLASH_STRING "two tons of tiny tuna teeth"
#define MX_FLASH_BASE 0xffe00000
#define MX_FLASH_ETHERNET_BASE 0xfff00000
#define MX_FLASH_PERMANENT_START 0xfff00100
#define MX_FLASH_EXTENDED_COUNT  0xfff00008
#define MX_FLASH_EXTENDED_BASE   0xfff0000c
#define MX_FLASH_MAX_EXTENDED ((MX_FLASH_PERMANENT_START - MX_FLASH_EXTENDED_BASE) / 4)
#define MX_FLASH_EXTENDED_ADDRESS(n) ((int*)(MX_FLASH_EXTENDED_BASE + n * 4))
#define MX_FLASH_EXTENDED_VALUE(n) (*(int*)(MX_FLASH_EXTENDED_BASE + n * 4))
#define MX_FLASH_MAX_IMAGE (1024*1024)
#define MX_FLASH_MAX_ERRORS 2

#define MX_FLASH_SAN_BITS_WORD 0
#define MX_FLASH_PRODUCT_TYPE_WORD 1

#define MX_FLASH_VARIABLE 0
#define MX_FLASH_PERMANENT 1
#define MX_FLASH_EXTENDED 2

#define MX_TEST_MTU 1024
#define MX_TEST_STRING "Tamburlaine, the scourge of God must die."

enum
{
  MX_TEST_READ_CHIP = 0,
  MX_TEST_READ_IMPEDENCE_TEST,
  MX_TEST_READ_IMPEDENCE,
  MX_TEST_WRITE_IMPEDENCE_TEST,
  MX_TEST_WRITE_IMPEDENCE,
  MX_TEST_READ_PACKET_COUNTERS,
  MX_TEST_READ_LINK_STATUS,
  MX_TEST_READ_CONTROL,
  MX_TEST_WRITE_CONTROL,
  MX_TEST_READ_GLOBAL_CONTROL,
  MX_TEST_WRITE_GLOBAL_CONTROL,
  MX_TEST_ENABLE_XBAR_UPDATE,
  MX_TEST_DISABLE_XBAR_UPDATE,
  MX_TEST_ENABLE_XBAR_IMP_UPDATE,
  MX_TEST_DISABLE_XBAR_IMP_UPDATE,
  MX_TEST_RESET_XBAR,
  MX_TEST_READ_A2D,
  MX_TEST_SET_RELAYS,
  MX_TEST_ACCESS_UC,
  MX_TEST_WRITE_ICS,
  MX_TEST_KILL_PORT,
  MX_TEST_TURN_ON_BEAT_SHUTDOWN,
  MX_TEST_TURN_OFF_BEAT_SHUTDOWN,
  MX_TEST_GET_VERSION_STRING,
  MX_TEST_REBOOT, 
  MX_TEST_CAUSE_FAULT,
  MX_TEST_GET_UPTIME,
  MX_TEST_GET_EXTENDED_COUNT,
  MX_TEST_GET_EXTENDED_VALUE,
  MX_TEST_SET_PORT_CONTROL,
  MX_TEST_SET_TIMEOUT,
  MX_TEST_GET_TIMEOUT,
  MX_TEST_GET_PORT_STATE,
  MX_TEST_CLEAR_COUNTERS,

  MX_TEST_GET_SWITCH_TEMP,
  MX_TEST_GET_PRODUCT_TYPE,
  MX_TEST_GET_PORT_STATES,
  MX_TEST_GET_SELF_MX_TEST_RESULT,
  MX_TEST_GET_SWITCH_IS_ON,

  MX_TEST_TURN_HA_ON,
  MX_TEST_TURN_HA_OFF,
  MX_TEST_TURN_AUTO_ON,
  MX_TEST_TURN_AUTO_OFF,

  MX_TEST_NUM_COMMANDS /*leave at end*/
};



#define MX_POLL_USECS 20
#define MX_IDLE_ETHERNET_USECS (1000 * 1000 * 2)
#define MX_BUSY_ETHERNET_USECS (1000 * 100)
#define MX_RARP_USECS (1000 * 1000 * 1)

#endif /*mx_defines_h*/
