#ifndef HW_INCLUDED
#define HW_INCLUDED


#define HW_NUM_PORTS 16

#define HW_READ_CHIP_ID 0x80
#define HW_READ_IMPEDENCE_TEST 0x81
#define HW_WRITE_IMPEDENCE_TEST 0xc1
#define HW_READ_IMPEDENCE 0x82
#define HW_WRITE_IMPEDENCE 0xc2
#define HW_READ_PACKET_COUNTERS 0x84
#define HW_READ_LINK_STATUS 0x85
#define HW_READ_CONTROL 0x86
#define HW_WRITE_CONTROL 0xc6
#define HW_READ_GLOBAL_CONTROL 0x87
#define HW_WRITE_GLOBAL_CONTROL 0xc7

#define HW_BYTE_BIT(b,n)(b & (1<<n))
#define HW_BYTE_SET(b,n){*(b) |= (1 << n);}

#define HW_RECEIVE_ILLEGAL_SYMBOL(b)       HW_BYTE_BIT(b, 7)
#define HW_RECEIVE_MISSED_3_BEATS(b)       HW_BYTE_BIT(b, 6)
#define HW_RECEIVE_NO_BEAT(b)              HW_BYTE_BIT(b, 5)
#define HW_RECEIVE_PORT_OFF(b)             HW_BYTE_BIT(b, 4)
#define HW_RECEIVE_NOT_IN_GO(b)            HW_BYTE_BIT(b, 3)
#define HW_RECEIVE_NOT_GAP(b)              HW_BYTE_BIT(b, 2)
#define HW_RECEIVE_INVALID_HEAD(b)         HW_BYTE_BIT(b, 1)
#define HW_RECEIVE_DATA_IN(b)              HW_BYTE_BIT(b, 0)

#define HW_TRANSMIT_NOT_GAP(b)             HW_BYTE_BIT(b, 7)
#define HW_TRANSMIT_NOT_IN_GO(b)           HW_BYTE_BIT(b, 6)
#define HW_TRANSMIT_DATA_OUT(b)            HW_BYTE_BIT(b, 5)

#define HW_CONTROL_TRANSMIT_OFF(b)         HW_BYTE_BIT(b, 7)
#define HW_CONTROL_RECEIVE_OFF(b)          HW_BYTE_BIT(b, 6)
#define HW_CONTROL_MISSING_BEAT_SDE(b)     HW_BYTE_BIT(b, 5)
#define HW_CONTROL_ILLEGAL_SYMBOL_SDE(b)   HW_BYTE_BIT(b, 4)

#define HW_GLOBAL_CONTROL_WIN1(b)          HW_BYTE_BIT(b,7)
#define HW_GLOBAL_CONTROL_WIN0(b)          HW_BYTE_BIT(b,6)

#define HW_SET_CONTROL_TRANSMIT_OFF(b)     HW_BYTE_SET(b, 7)
#define HW_SET_CONTROL_RECEIVE_OFF(b)      HW_BYTE_SET(b, 6)


#define HW_STAT_ILL_RCVD      0x80
#define HW_STAT_MISS3_BEAT    0x40
/*
#define HW_STAT_NO_BEAT       0x20
*/
#define HW_STAT_PORT_OFF      0x10

#define HW_CTRL_XMIT_OFF        0x80
#define HW_CTRL_RECV_OFF        0x40
#define HW_CTRL_MISS_BEAT_OFF   0x20
#define HW_CTRL_ILL_OFF         0x10


typedef char hw_char;
typedef int hw_int ;

typedef struct hw_chip_id
{
  hw_char high;
  hw_char low;
}hw_chip_id;

typedef struct hw_impedence_test
{
  hw_char high;
  hw_char low;
} hw_impedence_test;

typedef struct hw_impedence
{
  hw_char high1;
  hw_char low1;
  hw_char high2;
  hw_char low2;
} hw_impedence;

typedef struct hw_packet_counter
{
  hw_char crcHigh;
  hw_char crcLow;
  hw_char goodHigh;
  hw_char goodLow;
} hw_packet_counter;

typedef struct hw_packet_counters
{
  hw_packet_counter counters[HW_NUM_PORTS];
} hw_packet_counters;

typedef struct hw_link_status
{
  hw_char receive [HW_NUM_PORTS];
  hw_char transmit [HW_NUM_PORTS];
} hw_link_status;

typedef struct hw_control
{
  hw_char control [HW_NUM_PORTS];
} hw_control;

typedef struct hw_global_control
{
  hw_char control;
} hw_global_control;

hw_int hw_init ();
void hw_read_chip_id (hw_chip_id*p);
void hw_read_impedence_test (hw_impedence_test*p);
void hw_write_impedence_test (hw_impedence_test*p);
void hw_write_impedence (hw_impedence*p);
void hw_read_impedence (hw_impedence*p);
void hw_read_packet_counters (hw_packet_counters*p);
void hw_read_link_status (hw_link_status*p);
void hw_read_control (hw_control*p);
void hw_write_control (hw_control*p);
void hw_read_global_control (hw_global_control*p);
void hw_write_global_control (hw_global_control*p);
void hw_kill_port (hw_int port);


#define HW2_WRITE_SPEED  0xc3
#define HW2_READ_SPEED 0x83

#define HW2_RECEIVE_ILL 0
#define HW2_RECEIVE_MISS_3_BEATS 1
#define HW2_RECEIVE_NO_BEAT 2
#define HW2_RECEIVE_PORT_OFF 3
#define HW2_RECEIVE_IN_GO 4
#define HW2_RECEIVE_GAP 5
#define HW2_RECEIVE_INVALID_HEAD 6
#define HW2_RECEIVE_DATA_IN 7
#define HW2_RECEIVE_AUTO_PORT_OFF 8
#define HW2_RECEIVE_AUTO_TO 9

#define HW2_TRANSMIT_SEND_GAP 1
#define HW2_TRANSMIT_IN_GAP 2
#define HW2_TRANSMIT_DATA_OUT 3
#define HW2_TRANSMIT_AUTO_TO 4

typedef struct hw2_speed
{
  hw_char bytes [4];
}hw2_speed;

typedef struct hw2_impedence
{
  hw_char high;
  hw_char low;
} hw2_impedence;

typedef struct hw2_link_status
{
  hw_char receive [12 * 16 / 8];
  hw_char transmit [4 * 16 / 8];
} hw2_link_status;


void hw2_write_speed (hw2_speed*p);
void hw2_read_speed (hw2_speed*p);
hw_int hw2_get_speed (hw2_speed*p, hw_int port);
void hw2_set_speed (hw2_speed*p, hw_int port, hw_int b);

void hw2_write_impedence (hw2_impedence*p);
void hw2_read_impedence (hw2_impedence*p);
hw_int hw2_get_link_status_receive (hw2_link_status*p, hw_int port, hw_int field);
hw_int hw2_get_link_status_send (hw2_link_status*p, hw_int port, hw_int field);

void turn_ha_on ();
void turn_ha_off ();
void turn_auto_on ();
void turn_auto_off ();

#endif /*HW_INCLUDED*/
