/*
  st_Mapper.c
  myricom mapper
  finucane@myri.com (David Finucane)
*/


#include "insist.h"
#include "mt_Network.h"
#include "mt_MapFile.h"
#include "st_Mapper.h"

st_Mapper::st_Mapper (mt_Node*node, mt_Network*network, mt_Calculator*calculator, mt_MapperOptions&options)
  : mt_Mapper (node, network, calculator, options)
{
}

st_Mapper::~st_Mapper ()
{
}


void st_Mapper::dump (FILE*)
{
}

mt_Graph*st_Mapper::makeGraph (char*filename)
{
  mt_MapFile*mf = 0;
  mt_Graph*g = 0;

  insist (this);
  insist (filename && *filename);
  
  g = new mt_Graph ();
  insistp (g, ("st_Mapper::makeGraph: alloc failed"));
  
  mf = new mt_MapFile (filename, mt_File::_READ);
  insistp (mf, ("st_Mapper::makeGraph: alloc failed"));
  
  if (!mf->read (g))
  {
    delete mf;
    delete g;
    return 0;
  }

  delete mf;
  return g;

  exception:
  if (mf) delete mf;
  if (g) delete g;
  return 0;
}

int st_Mapper::start ()
{  
  mt_Network*network = 0;
  mt_Graph*graph = 0;
  char hostname [mt_Network::HOSTNAME_LENGTH];
  mt_Address address;
  int mapVersion = 0;
  int phase = 1;
  int hostType;
  mt_Node*root;
  
  insist (this);
  network = getNetwork ();
  insist (network);

  mt_mapper_c (("opening network."));
  
  if (!network->open (this, &address, hostname, &hostType, options.unit, options.numReceiveBuffers))
    return 0;

  if (!formatHostname (hostname, options.unit))
    return 0;
  
  mt_mapper_c (("setting hostname to %s", hostname));
  network->setHostname (this, network->getGmId (this), hostname);
  
  if (options.justSetHostname)
  {
    mt_mapper_c (("just set hostname."));
    network->close (this);
    return 1;
  }

  mt_mapper_c (("setting map level."));
  network->setLevel (this, options.level);  

  mt_mapper_c (("making graph."));
  if (!(graph = makeGraph (options.mapFile)))
    goto exception;

  mt_mapper_c (("finding myself."));
  char*hn;
  hn = *options.mapperName ? options.mapperName : hostname;
  
  if (!(root = graph->getNode (hn)) || !root->isHost ())
  {
    printFormat ("node \"%s\" is not a host in map file \"%s\"", hn, options.mapFile);
    goto exception;
  }

  mt_mapper_c (("I have found myself. I am called %s.", root->getName ()));
  mt_mapper_c (("computing routes to send configure messages on"));
  
  if (!graph->setRoutes (root))
    goto exception;

  mt_mapper_c (("making a host table from the graph"));

  if (!makeHostTable (*options.hostFile ? options.hostFile : 0, graph))
    goto exception;
  
  while (!network->isAborted ())
  {    
    mt_mapper_c (("deciding if I should configure the network"));
  
    int configured = isConfigured (graph, mapVersion);
    if (!configured)
    {
      printFormat ("configuring...");
      configured = configure (graph, mapVersion, root->getTypeIndex (), &phase);
      printFormat ("network is%s configured.", configured ? "" : " not");
    }
    
    writeCounters (options.countersFile);
    
    if (configured && options.mapOnce)
    {
      mt_mapper_c (("The network is configured, and map-once is set. I'm done."));
      break;
    }
    mt_mapper_c (("The network %s configured.", configured ? "is" : "is not yet"));
      
    mt_Route change;
    int isHost;
    
    if (options.verify &&
	!verify (graph, root, &phase, mapVersion, &address, options.level, &change, &isHost, hostname))
    {
      printVerifyProblem (graph, root, &change, isHost, hostname);
    }
    int m = options.activeMilliseconds;

    mt_mapper_c (("sleeping for %d milliseconds", m));
    
    for (;m > 1000; m-=1000);
    {
      if (network->isAborted ())
	goto exception;
      network->setTimer (this, 1000*1000);
      wait ();
    }
    insist (m > 0 && m <= 1000);
    network->setTimer (this, 1000*m);
    wait ();
  }
  
  mt_mapper_c (("done mapping"));
    
  delete graph;
  network->close (this);
  return 1;
  
  exception:
  if (graph) delete graph;
  if (network) network->close (this);
  return 0;
}

mt_Node*st_Mapper::newNode (int, char*, char*)
{
  insist (0);
  exception: return 0;
}

void st_Mapper::callHandler (int, mt_Message*, int)
{
}
