/*
  sc_Switch.c
  simple calculator
  finucane@myri.com (David Finucane)
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "insist.h"
#include "sc_Switch.h"

sc_Switch::sc_Switch (char*name, char*type) : mt_Switch (name, type)
{
  for (int i = 0; i < NUM_PORTS; i++)
    loads [i] = 0;
}


int sc_Switch::getLoad (int p)
{
  insist (this);  
  insist (p >= 0 && p < NUM_PORTS);
  return loads [p];
  exception: return 0;
}

void sc_Switch::setLoad (int p, int n)
{
  insist (this);
  insist (p >= 0 && p < NUM_PORTS);
  loads [p] = n;
  exception: return;
}

void sc_Switch::clearLoads ()
{
  insist (this);
  for (int i = 0; i < NUM_PORTS; i++)
    loads [i] = 0;
  exception: return;
}

void sc_Switch::reverseNegativeLoads ()
{
  insist (this);
  for (int i = 0; i < NUM_PORTS; i++)
    if (loads [i] < 0)
      loads [i] *= -2;
  
  exception: return;
}
  
double sc_Switch::getSquaredSumOfLoads ()
{
  insist (this);
  
  double d;
  d = 0;
  
  for (int i = 0; i < NUM_PORTS; i++)
    d += loads[i]*loads[i];
  
  return d;
  exception: return 0;
}
  
double sc_Switch::getScaledSumOfLoads ()
{
  insist (this);
  
  int cc;
  cc = getMaxNodes ();
  insist (cc > 0);
  
  return getSquaredSumOfLoads () / (double) cc;

  exception: return 0;
}
  
int sc_Switch::compareLoads (int a, int b)
{
  insist (this);
  insist (a >= 0 && a < NUM_PORTS);
  insist (b >= 0 && b < NUM_PORTS);

  mt_Node*na;
  na = getNode (a);
  mt_Node*nb;
  nb = getNode (b);
  
  insist (na);
  insist (nb);

  double sa, sb;
  
  if (loads[a] > loads[b])
    return 1;
  else if (loads[a] < loads[b])
    return -1;

  if (na->isHost() || nb->isHost())
    return 0;

  sa = ((sc_Switch*)na)->getScaledSumOfLoads();
  sb = ((sc_Switch*)nb)->getScaledSumOfLoads();
    
  if (sa > sb)
    return 1;
  else if (sa < sb)
    return -1;
  else return 0;
  exception: return 0;
}

int sc_Switch::getPorts (int list[])
{
  int numPorts = 0;
  
  insist (this);
  
  for (int i = 0; i < NUM_PORTS; i++)
  {
    if (getNode (i))
      list [numPorts++] = i;
  }
  
  /*shuffle*/

  for (int i = 0; i < numPorts - 1; i++)
  {
    int c = i + 1 + rand (numPorts - 1 -i);
    insist (c > i && c < numPorts);
    int t = list [i];
    list [i] = list [c];
    list [c] = t;
  }

  /*sort*/
  for (int i = 0; i < numPorts; i++)
  {
    for (int j = i + 1; j < numPorts; j++)
    {
      if (compareLoads (list[i], list[j]) > 0)
      {
	int t = list[j];
	list[j] = list[i];
	list[i] = t;
      }
    }
  } 
  return numPorts;
  exception: return 0;
}
