/*
  sc_Host.h
  simple calculator
  finucane@myri.com (David Finucane)
*/

#include "insist.h"
#include "sc_Host.h"

sc_Host::sc_Host (char*name, char*type, int maxRoutes) : mt_Host (name, type)
{
  this->maxRoutes = numRoutes = 0;
  routes = 0;
  costs = 0;
  
  insist (maxRoutes >= 1);
  
  routes = new mt_Route [maxRoutes];
  insistp (routes, ("sc_Host: alloc failed"));
  costs = new int [maxRoutes];
  insistp (costs, ("sc_Host: alloc failed"));

  this-> maxRoutes = maxRoutes;
  
  exception:;
}

sc_Host::~sc_Host ()
{
  insist (this);
  if (routes) delete [] routes;
  if (costs) delete [] costs;
  exception:;
}

void sc_Host::setRoute (int n, const mt_Route&r)
{
  insist (this);
  insist (n == 0);
  addRoute (r, 0);
  
  exception:;
}

int sc_Host::replaceRoute (int n, mt_Route*r)
{
  insist (this);
  insist (n >= 0 && n < numRoutes);
  insist (r);
  
  routes [n] = *r;
  return 1;
  exception: return 0;
}

int sc_Host::addRoute (const mt_Route&r, int cost,  mt_Route*old)
{
  insist (this);
  
  if (old) old->empty ();
  
  if (numRoutes < maxRoutes)
  {
    routes [numRoutes] = r;
    costs [numRoutes++] = cost;
  }
  else
  {
    int high = -1;
    for (int i = 0; i < numRoutes; i++)
      if (high == -1 || costs [i] < costs [high])
	high = i;
    
    insist (high >= 0 && high < numRoutes);
  
    if (high < cost) //latest
      return 0;
    
    if (old) *old = routes [high];
    routes [high] = r;
    costs [high] = cost;
  }
  return 1;
  
  exception: return 0;
}

mt_Route*sc_Host::getRoute (int n)
{
  insist (this);
  insist (n >= 0 && n <= numRoutes);
  insist (numRoutes <= maxRoutes);
  return &routes [n];
  exception: return 0;
}

int sc_Host::getNumRoutes ()
{
  insist (this);
  return numRoutes;
  exception: return 0;
}

void sc_Host::clearRoutes ()
{
  insist (this);
  numRoutes = 0;
  exception:;
}
