/*
  sc_Calculator.h
  simple calculator
  finucane@myri.com (David Finucane)
*/

#ifndef sc_Calculator_h
#define sc_Calculator_h

#include "mt_Route.h"
#include "mt_Calculator.h"
#include "mt_RouteTable.h"
#include "sc_Host.h"
#include "sc_Switch.h"

class sc_Calculator : public mt_Calculator
{
  private:
  int weight;
  int prune;
  int margin;
  sc_Host*root;
  int numRoots;
  char **roots;
  int useNumbers;
  int saveRoutes;
  int useTable;
  mt_RouteTable*routeTable;
  int maxRoutes;
  int disjoin;
  int index;
  int spread;
  
  int followRoute (mt_Node*from, mt_Node*to, mt_Route*r, int d = 0);

  private:
  int computeRoutes (sc_Host*from);
  int computeManyRoutes (sc_Host*from);
  int makeRouteTable ();
  void reverseNegativeLoads ();
  int spreadRoutes (sc_Host*from);
  
  public:
  sc_Calculator();
  ~sc_Calculator();
  int getRoute (int from, int to, int routeIndex, mt_Route*route);
  int isBetterRoute (mt_Node*from, mt_Node*to, mt_Route*r, int margin);
  void addRoute (mt_Node*from, mt_Node*to, mt_Route*r, int weight = 1);
  void removeRoute (mt_Node*from, mt_Node*to, mt_Route*r, int weight);
  void removeRoute (mt_Node*from, mt_Node*to, int weight = 1);
  void clearMarks ();
  void clearLoads ();
  void clearRoutes ();
  virtual int getMaxRoutes ();
  virtual int getNumRoutes (int from);
  virtual int getNumRoutes (int from, int to);

  virtual mt_Node*newNode (int nodeType, char*name, char*type);
  virtual void usage ();
  virtual int parseArgs (mt_Args*args);
  virtual int initialize (mt_Graph*graph, mt_Node*root);
  virtual int initialize (char *mapFile);
  virtual void cleanup ();
};

#endif /*sc_Calculator_h*/
