/*
  pi_Options
  ping
  finucane@myri.com (David Finucane)
*/

#ifndef pi_Options_h
#define pi_Options_h

#include "mt_Args.h"
#include "mt_File.h"
#include "mt_Node.h"
#include "mt_Network.h"

class pi_Options : mt_Component
{
  public: 
  char myself [mt_Network::HOSTNAME_LENGTH + 1];
  char node  [mt_Network::HOSTNAME_LENGTH + 1];
  char mapFile [mt_File::FILENAME_LENGTH + 1];
  int routeLength;
  char hops [mt_Route::MAX_ROUTE];
  int unit;
  int timeout;
  int count;
  int size;
  int minSize;
  int maxSize;
  int incrementSize;
  int testSwitches;
  int testXbars;
  int testHosts;
  int inPort;
  int outPort;
  int port;
  int verbose;
  int forever;
  int fearless;
  int printXbars;
  int fillSlow;
  int fillFast;
  
  enum
  {
    MTU = 2000,
    MAX_UNIT = 16,
    MAX_TIMEOUT = 1000*1000*60
  };
  pi_Options ();
  void usage ();
  int parseArgs (mt_Args*args);

  private:
  int parseRoute (int argc, char*argv [], char*route);
};

#endif /*pi_Options_h*/
