/*
  pi_Options.c
  ping
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "insist.h"

#include "pi_Options.h"
#include "mt_Switch.h"

pi_Options::pi_Options ()
{
  *myself = 0;
  *node = 0;
  *mapFile = 0;
  unit = 0;
  timeout = 1000 * 10;
  routeLength = -1;
  count = 1;
  port = -1;
  verbose = 0;
  forever = 0;
  testXbars = 0;
  printXbars = 0;
}

void pi_Options::usage ()
{
  printFormat
  (
   "job-args:\n"
   "-unit <unit number>\n"
   "-test-switches | -test-hosts | -test-xbars\n"
   "-print-xbars\n"
   "-map-file <map file>]\n"
   "-myself <node name>]\n"
   "-node <node name>\n"
   "-port <integer>\n"
   "-in-port <integer>\n"
   "-out-port <integer>\n"
   "-count <integer>\n"
   "-size <integer>\n"
   "-min-size <integer>\n"
   "-max-size <ingeger>\n"
   "-increment-size <integer>\n"
   "-timeout <microseconds>\n"
   "-verbose\n"
   "-forever\n"
   "-fearless\n"
   "-fill-slow\n"
   "-fill-fast\n"
   "-route <hop> <hop> <hop>...\n"
   );
}


int pi_Options::parseRoute (int argc, char*argv [], char*route)
{
  insist (this);
  insist (argv && route);

  if (argc > mt_Route::MAX_ROUTE)
  {
    printFormat ("route longer than %d", mt_Route::MAX_ROUTE);
    return -1;
  }
  
  int length;
  length = 0;

  for (int i = 0; i < argc; i++, length++)
  {
    route [length] = atoi (argv [i]);
    if (route [length] < mt_Route::MIN_HOP ||
	route [length] > mt_Route::MAX_HOP)
    {
      printFormat ("%s must be between %d and %d",
		   argv [i], mt_Route::MIN_HOP,
		   argv [i], mt_Route::MAX_HOP);
      return -1;
    }
  }
  return length;
  exception: return -1;
}	   
    
int pi_Options::parseArgs (mt_Args*args)
{
  insist (this);
  insist (args);

  *myself = 0;
  *node = 0;
  *mapFile = 0;
  unit = 0;
  timeout = 1000 * 10;
  routeLength = -1;
  port = -1;
  count = 1;
  inPort = outPort = -1;
  size = minSize = maxSize = incrementSize = 0;
  testSwitches = testHosts = testXbars = 0;
  printXbars = 0;
  verbose = 0;
  forever = 0;
  fearless = 0;
  fillSlow = 0;
  fillFast = 0;
  
  int argc;  
  char**argv;
  argv = args->getArgs (mt_Args::JOB, &argc);
  
  for (int i = 0; i < argc; i++)
  {
    if (!strcmp (argv [i], "-map-file"))
    {
      if (++i == argc)
      {
	printFormat ("missing map-file");
	return 0;
      }
      strncpy (mapFile, argv [i], mt_File::FILENAME_LENGTH);
    }
    else if (!strcmp (argv[i], "-unit"))
    {
      if (++i == argc)
      {
	printFormat ("missing unit number");
	return 0;
      }
      unit = atoi (argv[i]);
      if (unit < 0 || unit > MAX_UNIT)
      {
	printFormat ("%s is not a legal unit number", argv[i]);
	return 0;
      }
    }
    else if (!strcmp (argv[i], "-count"))
    {
      if (++i == argc)
      {
	printFormat ("missing count");
	return 0;
      }
      count = atoi (argv[i]);
      if (count <= 0)
      {
	printFormat ("%s is not a legal count", argv[i]);
	return 0;
      }
    }
    else if (!strcmp (argv[i], "-timeout"))
    {
      if (++i == argc)
      {
	printFormat ("missing timeout");
	return 0;
      }
      timeout = atoi (argv[i]);
      if (timeout < 0 || timeout > MAX_TIMEOUT)
      {
	printFormat ("%s is not a legal timeout", argv[i]);
	return 0;
      }
    }
    else if (!strcmp (argv[i], "-port"))
    {
      if (++i == argc)
      {
	printFormat ("missing port");
	return 0;
      }
      port = atoi (argv[i]);
      if (port < 0 || port > mt_Switch::NUM_PORTS)
      {
	printFormat ("%s is not a legal port", argv[i]);
	return 0;
      }
    }
    else if (!strcmp (argv[i], "-in-port"))
    {
      if (++i == argc)
      {
	printFormat ("missing in-port");
	return 0;
      }
      inPort = atoi (argv[i]);
      if (inPort < 0 || inPort > mt_Switch::NUM_PORTS)
      {
	printFormat ("%s is not a legal port", argv[i]);
	return 0;
      }
    }
    else if (!strcmp (argv[i], "-out-port"))
    {
      if (++i == argc)
      {
	printFormat ("missing port");
	return 0;
      }
      outPort = atoi (argv[i]);
      if (outPort < 0 || outPort > mt_Switch::NUM_PORTS)
      {
	printFormat ("%s is not a legal out-port", argv[i]);
	return 0;
      }
    }
    else if (!strcmp (argv [i], "-myself"))
    {
      if (++i == argc)
      {
	printFormat ("missing -myself");
	return 0;
      }
      strncpy (myself, argv [i], mt_Network::HOSTNAME_LENGTH);
    }
    else if (!strcmp (argv [i], "-node"))
    {
      if (++i == argc)
      {
	printFormat ("missing -node");
	return 0;
      }
      strncpy (node, argv [i], mt_Network::HOSTNAME_LENGTH);
    }
    else if (!strcmp (argv [i], "-size"))
    {
      if (++i == argc)
      {
	printFormat ("missing size");
	return 0;
      }
      size = atoi (argv[i]);
      if (size <= 0 || size > MTU)
      {
	printFormat ("%s is not a legal size", argv[i]);
	return 0;
      }
    }
    else if (!strcmp (argv [i], "-size"))
    {
      if (++i == argc)
      {
	printFormat ("missing size");
	return 0;
      }
      size = atoi (argv[i]);
      if (size <= 0 || size > MTU)
      {
	printFormat ("%s is not a legal size", argv[i]);
	return 0;
      }
    }
    else if (!strcmp (argv [i], "-min-size"))
    {
      if (++i == argc)
      {
	printFormat ("missing min-size");
	return 0;
      }
      minSize = atoi (argv[i]);
      if (minSize <= 0 || minSize > MTU)
      {
	printFormat ("%s is not a legal min-size", argv[i]);
	return 0;
      }
    }
    else if (!strcmp (argv [i], "-max-size"))
    {
      if (++i == argc)
      {
	printFormat ("missing max-size");
	return 0;
      }
      maxSize = atoi (argv[i]);
      if (maxSize <= 0 || maxSize > MTU)
      {
	printFormat ("%s is not a legal maxSize", argv[i]);
	return 0;
      }
    } 
    else if (!strcmp (argv [i], "-increment-size"))
    {
      if (++i == argc)
      {
	printFormat ("missing increment-size");
	return 0;
      }
      incrementSize = atoi (argv[i]);
      if (incrementSize <= 0 || incrementSize > MTU)
      {
	printFormat ("%s is not a legal increment-size", argv[i]);
	return 0;
      }
    }
    else if (!strcmp (argv [i], "-fill-slow"))
    {
      fillSlow = 1;
    }
    else if (!strcmp (argv [i], "-fill-fast"))
    {
      fillFast = 1;
    }
    else if (!strcmp (argv [i], "-print-xbars"))
    {
      printXbars = 1;
    }
    else if (!strcmp (argv [i], "-test-switches"))
    {
      testSwitches = 1;
    }
    else if (!strcmp (argv [i], "-test-hosts"))
    {
      testHosts = 1;
    }
    else if (!strcmp (argv [i], "-test-xbars"))
    {
      testXbars = 1;
    }
    else if (!strcmp (argv [i], "-verbose"))
    {
      verbose = 1;
    }
    else if (!strcmp (argv [i], "-forever"))
    {
      forever = 1;
    }
    else if (!strcmp (argv [i], "-fearless"))
    {
      fearless = 1;
    }
    else if (!strcmp (argv [i], "-route"))
    {
      routeLength = parseRoute (argc - (i + 1), &argv [i + 1], hops);
      if (routeLength < 0)
	return 0;
      i+=routeLength;
    }
    else
    {
      printFormat ("unknown option %s", argv [i]);
      return 0;
    }
  }
  if (minSize > maxSize)
  {
    printFormat ("minSize %d cannot be more than maxSize %d\n",
		 minSize, maxSize);
    return 0;
  }
  if (!testHosts && !testSwitches && !testXbars)
  {
    printFormat ("must specify -test-host or -test-switches or test-xbars");
    return 0;
  }
  
  return 1;
  exception: return 0;
}
