/*
  nw_Simulation.h
  nway
  finucane@myri.com (David Finucane)
*/

#ifndef nw_Simulation_h
#define nw_Simulation_h

#include <stdio.h>

#include "mt_Simulation.h"
#include "mt_Job.h"
#include "mt_Network.h"
#include "mt_Queue.h"

class nw_Job;

class nw_Simulation: public mt_Simulation
{
  private:

  int packetLength;
  int meanDelay;
  int selfSend;
  int highPriorityPercent;
  char histFile [mt_File::FILENAME_LENGTH];
  char trafficFile [mt_File::FILENAME_LENGTH];
  int longestRoute;
  int shuffleRoutes;
  int sendAcks;

  enum
  {
    NUM_BINS = 1000,
    BIN_SIZE = 100,
    MAX_LEVELS = 100
  };
  
  double latencyTotal [2];
  int latencyNum [2];
  int lbinNum [2] [NUM_BINS];
  int numLevels;
  double levelPercents [MAX_LEVELS];
  
  friend class nw_Job;
  
  public:
  
  nw_Simulation();

  virtual mt_Job*newJob (mt_Node*node, mt_Network*network, mt_Calculator*calc);
  virtual void usage ();
  virtual int parseArgs (mt_Args*args);

  void simpleDump (mt_Network*network, FILE *fp);
  void dump (mt_Network*network);
};


class nw_Job: public mt_Job
{
  private:
  nw_Simulation *sim;
  mt_Node**hosts;
  mt_Node**levels [nw_Simulation::MAX_LEVELS];
  int hostsPerLevel [nw_Simulation::MAX_LEVELS];
  int lastLatency;
  int lastIncrement;
  mt_Queue ackQueue;

  static int*trafficPositions;
  static int*trafficDestinations;
  static int parseTrafficFile (char*filename, mt_Graph*g);
  
  int numSends;
  int numReceives;
  int to;
  int me;
  int numHosts;
  int *sends;
  int *receives;
  int *acks;
  
  void send ();
  void sendAfterDelay ();
  int getNeverSend (int i);
  int getNeverReceive (int i);
  int getNextDestination (int*to, int*delay);
  int pickHostFromLevel (int*host, int*delay, int level);
  int hasTraffic ();
  int getTrafficDestination (int source);
  int nw_Job::ackQueueFlush ();
  int nw_Job::ackQueueAppend (int to);
  
  public:
  nw_Job (mt_Node*node, mt_Network*network, nw_Simulation*sim);
  virtual ~nw_Job ();

  virtual void dump (FILE*fp);
  virtual int willWait ();
  virtual int start ();
  virtual void receive (int event, char*p, int length);
};

#endif /*nw_Simulation_h*/
