/*
  mm_Switch.h
  myrinet mapper
  finucane@myri.com (David Finucane)
*/

#ifndef mm_Switch_h
#define mm_Switch_h

#include "mm_Node.h"
#include "mt_Graph.h"

class mm_Switch : public mm_Node
{
  public:
  enum
  {
    MAX_SWITCH = 16,
    MAX_PORT = MAX_SWITCH,
    MIN_PORT = 1 - MAX_SWITCH,
    NUM_PORTS = MAX_PORT - MIN_PORT,
    NO_PORT = NUM_PORTS * 2
  };
  
  private:
  mm_Node*nodes [NUM_PORTS];
  char opposites [NUM_PORTS];
  int first;
  mm_Switch*duplicate;
  int alignment;
  int id;
  int inPort;
  int numPorts;
  int explored;
  
  public:
  mm_Switch (char*name, mt_Route*r, int id = 0, int inPort = 0, int numPorts = 0);
  ~mm_Switch ();
  virtual void disconnect (int p);
  int getExplored ();
  void setExplored (int explored);
  int getNumHosts ();
  int getNumDefined ();
  int inheritHosts (mm_Switch*s, int alignment);
  void finish ();
  void setDuplicate (mm_Switch*duplicate, int alignment);
  mm_Switch*merge (mt_Graph*graph, mt_Queue*queue);
  int getNumConnections ();
  virtual int getId ();
  int getInPort ();
  int getNumPorts ();
  int sever (int alignment,  mm_Switch*original, mm_Switch*ghost);

  int getPort (mm_Node*n);
  virtual int getFirst ();
  virtual void setFirst (int first);
  virtual int shift (int n);
  virtual mm_Node*mGetNode (int p);
  virtual int mGetOpposite (int p);
  virtual void  mConnect (int p, int o, mm_Node*n);
  
  virtual int getNodeType ();
  virtual int getMaxNodes ();
  virtual mt_Node*getNode (int p);
  virtual int getOpposite (int p);
  virtual void connect (int p, int o, mt_Node*n);
  virtual void connectMissingHost (int p, mt_Node*h);
};
  
#endif /*mm_Switch_h*/


