/*
  mm_Simulation.c
  myricom mapper
  finucane@myri.com
*/

#include <string.h>

#include "insist.h"
#include "mt_Responder.h"
#include "mt_MapperOptions.h"
#include "mm_Simulation.h"
#include "mm_Mapper.h"
#include "mt_CloudResponder.h"

mm_Simulation::mm_Simulation ()
{
  numHosts = 0;
}

mt_Job*mm_Simulation::newJob (mt_Node*node, mt_Network*network, mt_Calculator*calculator)
{
  insist (node->getNodeType () == mt_Node::CLOUD ||
	  node->getNodeType () == mt_Node::HOST);
  
  if (node->getNodeType () == mt_Node::CLOUD)
    return new mt_CloudResponder (node, network);
  else if ((!numHosts++ && !*options.mapperName) || !strcmp (node->getName (), options.mapperName))
    return new mm_Mapper (node, network, calculator, options);
  else
    return new mt_Responder (node, network);
  exception: return 0;
}

void mm_Simulation::usage ()
{
  options.usage ();
}

int mm_Simulation::parseArgs (mt_Args*args)
{
  return options.parseArgs (args);
}

