/*
  mm_MapperModule.c
  myricom mapper
  finucane@myri.com (David Finucane)
*/

#include "insist.h"
#include "mm_MapperModule.h"
#include "mm_Mapper.h"


mm_MapperModule::mm_MapperModule () : fake ("fake", "-")
{
  mapper = 0;
}

mm_MapperModule::~mm_MapperModule ()
{
  cleanup ();
}

int mm_MapperModule::parseArgs (mt_Args*args)
{
  return options.parseArgs (args);
}

void mm_MapperModule::usage ()
{
  options.usage ();
}

int mm_MapperModule::initialize (mt_Network*network, mt_Calculator*calculator)
{
  mapper = new mm_Mapper (&fake, network, calculator, options);
  insistp (mapper, ("mt_MapperModule::initialize: alloc failed"));
  return 1;
  exception: return 0;  
}

int mm_MapperModule::start ()
{
  insist (this);
  insist (mapper);
  return mapper->start ();
  exception: return 0;
}

void mm_MapperModule::cleanup ()
{
  insist (this);
  if (mapper)
    delete mapper;
  mapper = 0;
  exception: return;
};
