/*
  mm_Cloud.c
  myrinet mapper
  finucane@myri.com (David Finucane)
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "insist.h"
#include "mm_Switch.h"
#include "mm_Cloud.h"


int mm_Cloud::getNodeType ()
{
  return mt_Node::CLOUD;
}

mm_Cloud::mm_Cloud (mt_Address*a, mt_Route*route, int numNodes) : mm_Node (a->toString (), "-")
{
  
  nodes = 0;
  insist (a && route && numNodes > 0);
  
  setRoute (0, *route);
  this->address = *a;
  this->numNodes = numNodes;  
  sprintf (this->type, "%d", numNodes);
  
  nodes = new mm_Node* [numNodes];
  insistp (nodes, ("mm_Cloud::sm_Cloud: alloc of %d node pointers failed\n", numNodes));

  for (int i = 0; i < numNodes; i++)
    nodes [i] = 0;
  
  opposite = -1;
  
  exception: return;
}

mm_Cloud::~mm_Cloud ()
{
  if (nodes)
    delete nodes;
}

void mm_Cloud::disconnect (int p)
{
  insist (this);
  insist (p >= 0 && p < numNodes);
  
  nodes [p] = mm_Node::disconnected;
  
  exception: return;
}


void mm_Cloud::mConnect (int p, int o, mm_Node*n)
{
  insist (this);
  insist (n);
  insist (p >= 0 && p < numNodes);
  insist (o >= mm_Switch::MIN_PORT && o < mm_Switch::MAX_PORT);
  insist (!p || !o);
  
  nodes [p] = (mm_Node*)n;

  if (!p)
    opposite = o;
  
  exception: return;
}

mm_Node*mm_Cloud::mGetNode (int p)
{
  insist (this);
  insist (p >= 0 && p < numNodes);

  return nodes [p];
  
  exception: return 0;
}

int mm_Cloud::mGetOpposite (int p)
{
  insist (this);
  insist (p >= 0 && p < numNodes);

  if (p)
    return 0;
  else
    return opposite;

  exception: return -1;
}

int mm_Cloud::getMaxNodes ()
{
  return numNodes;
}

void mm_Cloud::connect (int p, int o, mt_Node*n)
{
  insist (this);
  insist (p >= 0 && p < numNodes);

  mm_Node*m;
  m = (mm_Node*)n;
  
  nodes [p] = m;
  if (!p)
    opposite = o + m->getFirst ();
  
  exception: return;
}

mt_Node*mm_Cloud::getNode (int p)
{
  insist (this);
  if (p < 0 || p >= numNodes)
    return 0;

  mm_Node*n;
  n = nodes [p];
  return n && n->isConnected () ? n : 0;
  
  exception: return 0;
}

int mm_Cloud::getOpposite (int p)
{
  insist (this);
  
  if (p < 0 || p >= numNodes)
    return 0;
    
  mm_Node*n;
  n = nodes [p];

  if (!n)
    return -1;
  
  if (p)
    return 0;
  else
    return n->shift (opposite);
  
  exception: return -1;
}

mt_Address*mm_Cloud::getAddress ()
{
  insist (this);
  return &this->address;
  exception: return 0;
}

char*mm_Cloud::toString (char*s)
{
  insist (this);
  insist (s);

  char buffer [30];
  
  char*t;
  t = s;

  s += strlen (mt_Node::toString (s));
  s += sprintf (s, "address %s\n", address.toString (buffer));
  
  return t;
  exception: return 0;
}

int mm_Cloud::getHostType ()
{
  insist (this);
  return this->hostType;
  exception: return 0;
}
