/*
  merlin.java
  Merlin
  (c) 1998 Myricom, Inc.
  finucane@myri.com (David Finucane)
  dmazzoni@myri.com (Dominic Mazzoni)

  Version 1.1: Released on 7/6/98
  Version 1.2: Released on 8/19/98

  Distribution site: http://www.myri.com/GM/merlin/
*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.awt.image.*;
import java.net.URL;

public class merlin extends Panel implements ActionListener, ItemListener, Runnable,
NodeListener, SelectFrameListener, WindowListener
{
  private static final String MAP_CARD = "Map";
  private static final String OPTIONS_CARD = "Options";
  private static final String HISTOGRAM_CARD = "Histogram";
  
  private Font font;
  public  Frame frame;
  private SelectFrame selectFrame;
  private OptionPanel optionPanel;
  private EasyFileDialog easyFileDialog;
  private Histogram histogram;

  // File Menu
  private MenuItem newItem;
  private MenuItem openItem;
  private MenuItem openSimItem;
  private MenuItem openRoutesItem;
  private MenuItem openCountersItem;
  private MenuItem openCompareItem;
  private MenuItem openAllTestItem;
  private MenuItem saveItem;
  private MenuItem printItem;
  private MenuItem quitItem;

  // Edit Menu
  private MenuItem selectAllItem;
  private MenuItem selectSwitchesItem;
  private MenuItem selectHostsItem;
  private MenuItem selectFrameItem; // Select Hosts...

  // Display
  private CheckboxMenuItem namesItem;
  private CheckboxMenuItem showHostsItem;
  private CheckboxMenuItem groupsItem;
  private CheckboxMenuItem routesItem;
  private CheckboxMenuItem numbersItem;
  private CheckboxMenuItem colorsItem;
  private CheckboxMenuItem allTestItem;
  private CheckboxMenuItem compareItem;
  private CheckboxMenuItem cycleItem;
  private CheckboxMenuItem spreadItem;
  private CheckboxMenuItem floatItem;

  private Tablet tablet;
  private ScrollPane scrollpane;
  private String mapFilename;
  private String routeFilename;
  private String allTestFilename;
  private String lastFileFound;
  
  private Button switch8Button;
  private Button switch16Button;
  private Button hostButton;
  private Button runButton;
  private Button treeButton;
  private Button circleButton;
  private Button levelButton;
  private Button copyButton;
  private Button compareNowButton;

  private Choice cardChoice;
  private Panel mainCardPanel;
  
  private Button errorButton;
  private boolean showingError = false;

  private String arch;
  private String directory = null;
  private Label errorLabel;
  private Thread refreshThread;
  private int refreshTime = 1000;
  private Thread floatThread;
  private Thread sunThread;
  private Relaxer sunRelaxer;
  private Relaxer floatRelaxer;

  int numMenuMaps=0;
  MenuItem menuMapItem[];
  String menuMapName[];

  private static String groupNames[] =
  {
    "oct.template"
  };
  
  private void addGb (Panel panel, GridBagLayout gb, GridBagConstraints c, Component o)
  {
    gb.setConstraints (o, c);
    panel.add (o);
  }

  public merlin (String [] arguments)
  {
    setBackground (Color.lightGray);

    Anatomy groups [] = new Anatomy [groupNames.length];
    for (int i = 0; i < groupNames.length; i++)
      groups [i] = new Anatomy (getClass().getResourceAsStream(groupNames [i]));
    
    tablet = new Tablet (groupNames, groups);
    tablet.addNodeListener (this);
    tablet.setSize (new Dimension(3000, 00));
    
    frame = new Frame ("Myricom Merlin 1.3");
    font = AppFont.getFont ("Dialog");
    frame.setFont (font);
    setFont (font);

    MenuBar menuBar = new MenuBar ();

    menuBar.setFont (font);

    Menu file = new Menu ("File");
    file.add (newItem = new MenuItem ("New Map"));
    file.addSeparator();
    file.add (openItem = new MenuItem ("Open Map..."));
    file.add (openRoutesItem = new MenuItem ("Open Routes..."));
    file.add (openSimItem = new MenuItem ("Open Sim Data..."));
    file.add (openCountersItem = new MenuItem ("Open Counters..."));
    file.add (openCompareItem = new MenuItem ("Open Compare..."));
    file.add (openAllTestItem = new MenuItem ("Open All to All Results..."));
    file.addSeparator();
    file.add (saveItem = new MenuItem ("Save..."));
    file.addSeparator();
    file.add (printItem = new MenuItem ("Print..."));
    file.addSeparator();
    file.add (quitItem = new MenuItem ("Quit"));

    Menu edit = new Menu ("Edit");
    edit.add (selectAllItem = new MenuItem ("Select All"));
    edit.add (selectHostsItem = new MenuItem ("Select All Hosts"));
    edit.add (selectSwitchesItem = new MenuItem ("Select All Switches"));
    edit.addSeparator();
    edit.add (selectFrameItem = new MenuItem ("Select Hosts..."));

    Menu display = new Menu ("Display");
    display.add (namesItem = new CheckboxMenuItem ("Show Names"));
    display.add (showHostsItem = new CheckboxMenuItem ("Show Hosts"));
    showHostsItem.setState (true);
    
    display.add (groupsItem = new CheckboxMenuItem ("Show Groups"));
    display.add (routesItem = new CheckboxMenuItem ("Show Routes"));
    display.add (numbersItem = new CheckboxMenuItem ("Show Numbers"));
    display.add (colorsItem = new CheckboxMenuItem ("Show Colors"));
    display.add (allTestItem = new CheckboxMenuItem ("Show All Test Results"));
    display.add (cycleItem = new CheckboxMenuItem ("Cycle"));
    display.add (compareItem = new CheckboxMenuItem ("Compare"));
    display.add (spreadItem = new CheckboxMenuItem ("Spread"));
    display.add (floatItem = new CheckboxMenuItem ("Float"));
    
    namesItem.addItemListener (this);
    showHostsItem.addItemListener (this);
    groupsItem.addItemListener (this);
    routesItem.addItemListener (this);
    numbersItem.addItemListener (this);
    colorsItem.addItemListener (this);
    allTestItem.addItemListener (this);
    cycleItem.addItemListener (this);
    compareItem.addItemListener (this);
    spreadItem.addItemListener (this);
    floatItem.addItemListener (this);
    
    String mapsDirName;
    String homeDir = System.getProperty("user.home");
    if (homeDir != null && homeDir.length() > 0)
    {
      String pathSep = System.getProperty("file.separator");
      String dotMerlinFN = homeDir + pathSep + ".merlin";
      try {
	FileInputStream dotMerlin = new FileInputStream(dotMerlinFN);
	FileReader freader = new FileReader(dotMerlin.getFD());
	LineNumberReader reader = new LineNumberReader (freader);
	mapsDirName = reader.readLine();
      }
      catch (Exception e)
      {
	mapsDirName = homeDir + pathSep + "maps";
      }
      try {
	File mapsDir = new File(mapsDirName);
	String list[] = mapsDir.list();
	numMenuMaps = 0;
	for(int i=0; i<list.length; i++)
	  if (list[i].endsWith(".map"))
	    numMenuMaps++;

	if (numMenuMaps > 0)
	{
	  display.addSeparator();
	  menuMapItem = new MenuItem[numMenuMaps];
	  menuMapName = new String[numMenuMaps];
	  
	  int c=0;
	  for(int i=0; i<list.length; i++)
	    if (list[i].endsWith(".map"))
	    {
	      menuMapItem[c] = new MenuItem(list[i]);
	      menuMapName[c] = mapsDirName + pathSep + list[i];
	      menuMapItem[c].addActionListener (this);
	      display.add (menuMapItem[c]);
	      c++;
	    }
	}
      }
      catch (Exception e)
      {
      }
    }

    newItem.addActionListener (this);
    openItem.addActionListener (this);
    openRoutesItem.addActionListener (this);
    openSimItem.addActionListener (this);
    openAllTestItem.addActionListener (this);
    printItem.addActionListener (this);
    openCountersItem.addActionListener (this);
    openCompareItem.addActionListener (this);
    saveItem.addActionListener (this);
    quitItem.addActionListener (this);

    selectAllItem.addActionListener (this);
    selectHostsItem.addActionListener (this);
    selectSwitchesItem.addActionListener (this);
    selectFrameItem.addActionListener (this);
    
    menuBar.add (file);
    menuBar.add (edit);
    menuBar.add (display);

    String s = "";
    try
    {
      s = System.getProperty ("user.name");
    }
    catch (Exception e)
    {
    }

    frame.add (this);
    setLayout (new BorderLayout());

    mainCardPanel = new Panel ();
    mainCardPanel.setLayout (new CardLayout ());
    add ("Center", mainCardPanel);
    
    scrollpane = new ScrollPane ();
    scrollpane.add (tablet, null, 0);
    
    mainCardPanel.add (MAP_CARD, scrollpane);
    mainCardPanel.add (OPTIONS_CARD, optionPanel = new OptionPanel ());
    mainCardPanel.add (HISTOGRAM_CARD, histogram = new Histogram ());
    
    Panel tools = new Panel ();
    tools.setLayout (new GridLayout (0, 1, 0, 0));
    this.add ("North", tools);
    
    Panel bottom = new Panel();
    bottom.setLayout (new BorderLayout());
    bottom.add ("West", errorButton = new Button ("OK"));
    bottom.add ("Center",  errorLabel = new Label (""));
    bottom.add ("East", new Label ("help@myri.com"));
    this.add ("South", bottom);

    errorButton.addActionListener (this);
    
    refreshThread = new Thread (this);
    refreshThread.start ();
    refreshThread.suspend ();


    GridBagLayout gb = new GridBagLayout ();
    GridBagConstraints c = new GridBagConstraints ();
    tools.setLayout (gb);
    
    c.fill = GridBagConstraints.NONE;
    c.gridx = GridBagConstraints.RELATIVE;
    c.anchor = GridBagConstraints.NORTHWEST;
    c.gridwidth = 1;

    addGb (tools, gb, c, cardChoice = new Choice ());
    cardChoice.add (MAP_CARD);
    cardChoice.add (OPTIONS_CARD);
    cardChoice.add (HISTOGRAM_CARD);
    cardChoice.addItemListener (this);
    
    addGb (tools, gb, c, switch8Button = new Button ("8-Switch"));
    addGb (tools, gb, c, switch16Button = new Button ("16-Switch"));
    addGb (tools, gb, c, hostButton = new Button ("Host"));
    addGb (tools, gb, c, copyButton = new Button ("Copy"));
    addGb (tools, gb, c, treeButton = new Button ("Tree"));
    addGb (tools, gb, c, circleButton = new Button ("Circle"));
    addGb (tools, gb, c, levelButton = new Button ("Level"));
    addGb (tools, gb, c, runButton = new Button ("Run"));
    
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.weightx = 1;

    addGb (tools, gb, c, compareNowButton = new Button ("Compare"));
    
    switch8Button.addActionListener (this);
    switch16Button.addActionListener (this);
    hostButton.addActionListener (this);
    copyButton.addActionListener (this);
    treeButton.addActionListener (this);
    circleButton.addActionListener (this);
    levelButton.addActionListener (this);
    runButton.addActionListener (this);
    compareNowButton.addActionListener (this);

    frame.addWindowListener (this);
    
    frame.setSize (550, 450);
    
    setTitle (null);
    arch = getArch ();

    easyFileDialog = new EasyFileDialog (frame, this.getFont());

    frame.setMenuBar (menuBar);
    frame.setVisible (true);

    if (arguments.length == 1)
      tablet.fromFile(arguments[0]);
  }
  private String getArch ()
  {
    String s = System.getProperty ("os.arch")+System.getProperty ("os.name");
    if (s.equals ("sparcSolaris"))
      return "sparc_solaris";
    else if (s.equals ("x86Windows NT"))
      return "intel_nt";
    else if (s.equals ("x86Linux"))
      return "intel_linux";
    else
    {
      System.out.println("Unknown system: "+s);
      return null;
    }
  }
  public void selectFrameCallback (String names[], boolean showRoutes)
  {
    tablet.showNodes (names, showRoutes);
  }
  public void nodeSelected (Node node)
  {
  }
  private void setError (String s)
  {    
    showingError = !s.trim().equals ("");
    errorLabel.setText (s);
  }

  
  private String getFilename (String title, String filter, int mode)
  {
    FileDialog d = new FileDialog (frame, title);
    d.setMode (mode);
    if (directory != null)
      d.setDirectory (directory);
    
    d.show ();
    if (d.getFile() == null)
      return null;
    return (directory = d.getDirectory ()) + d.getFile ();
  }
  private void setTitle (String s)
  {
    if (s!=null)
      frame.setTitle(s);
    else
      frame.setTitle("Myricom Merlin 1.2");
  }
  
  public synchronized void itemStateChanged (ItemEvent e)
  {
    Object object = (Object) e.getSource();
    boolean on = e.getStateChange() == ItemEvent.SELECTED;
    setError ("");

    if (object == cardChoice)
    {
	((CardLayout) mainCardPanel.getLayout ()).show (mainCardPanel, cardChoice.getSelectedItem ());
    }
    else if (object == routesItem)
      tablet.setRoutes (on);
    else if (object == numbersItem)
      tablet.setNumbers (on);
    else if (object == colorsItem)
      tablet.setColors (on);
    else if (object == allTestItem)
      tablet.setAllTest (on);
    else if (object == namesItem)
      tablet.setShowNames (on);
    else if (object == showHostsItem)
      tablet.setHideHosts (!on);
    else if (object == groupsItem)
      tablet.setShowGroups (on);
    else if (object == cycleItem)
    {
      if (on)
	refreshThread.resume ();
      else
	refreshThread.suspend ();
    }
    else if (object == compareItem)
    {
      tablet.setCompare (on);
    }
    else if (object == floatItem)
    {
      if (on)
      {
	floatThread = new Thread (floatRelaxer = 
				  new Relaxer (false, 25, tablet, scrollpane));
	floatThread.setPriority(Thread.MIN_PRIORITY);
	floatThread.start();
      }
      else
      {
	floatRelaxer.die ();
	try
	{
	  floatThread.wait ();
	}
	catch (Exception ex)
	{
	}
      }
    }
    else if (object == spreadItem)
    {
      if (on)
      {
	sunThread = new Thread (sunRelaxer = 
				new Relaxer (true, 25, tablet, scrollpane ));
	sunThread.setPriority(Thread.MIN_PRIORITY);
	sunThread.start();
      }
      else
      {
	sunRelaxer.die ();
	try
	{
	  sunThread.wait ();
	}
	catch (Exception ex)
	{
	}
      }
    }
  }
  public synchronized void actionPerformed (ActionEvent e)
  {
    Object object = e.getSource ();
    setError ("");

    for(int i=0; i<numMenuMaps; i++)
    {
      if (object == menuMapItem[i])
      {
	mapFilename = menuMapName[i];
	tablet.fromFile (mapFilename);
	if (!tablet.getPositioned ())
	  tablet.circle (scrollpane.getViewportSize());
	return;
      }
    }
    if (object == errorButton)
    {
      setError ("");
    }
    else if (object == newItem)
    {
      tablet.selectAll();
      tablet.deleteSelectedNodes();
      tablet.repaint();
      setTitle("untitled");
      mapFilename = null;
    }
    else if (object == openItem)
    {
      String filename = getFilename ("Open", "map", FileDialog.LOAD);
      if (filename == null)
	return;
      
      Cursor c = getCursor ();
      setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));

      setTitle (lastFileFound);
      tablet.fromFile (filename);
      if (!tablet.getPositioned ())
	tablet.circle (scrollpane.getViewportSize());

      setCursor (c);
     
      mapFilename = filename;
    }
    else if (object == selectFrameItem)
    {
      if (selectFrame == null)
	selectFrame = new SelectFrame (font, this);
      
      selectFrame.setVisible (true);
    }
    else if (object == openSimItem)
    {
      String filename = getFilename ("Open Simulation Data","sim", FileDialog.LOAD);
      if (filename == null)
	return;

      Cursor c = getCursor ();
      setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));
      
      if (tablet.fromSimulation (filename))
	setError ("Deadlock detected");
      else
	setError ("");

      setCursor (c);
      repaint ();
    }
    else if (object == openRoutesItem)
    {
      String filename = getFilename ("Open Routes","routes", FileDialog.LOAD);
      if (filename == null)
	return;

      Cursor c = getCursor ();
      setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));
      
      tablet.readRoutes (filename);
      routeFilename = filename;

      setCursor (c);
      repaint ();
    }
    else if (object == openAllTestItem)
    {
      String filename = getFilename ("Open All to All Results", "test", FileDialog.LOAD);
      if (filename == null)
	return;
      
      Cursor c = getCursor ();
      setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));
      
      if (!tablet.readAllTest (filename))
	setError ("problem reading test results file. (Does the routes file match?)");
      else
	allTestFilename = filename;

      setCursor (c);
      repaint ();
    }
    else if (object == printItem)
    {
      Properties props= new Properties();

      props.put("awt.print.printer", "lpr");
      props.put("awt.print.", "printer");

      PrintJob pj = getToolkit().getPrintJob(frame, "Printed Page", props);
      if (pj == null)
	return;

      Cursor c = getCursor ();
      setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));

      Graphics pg = pj.getGraphics();

      //scrollpane.getViewport().print(pg);
      //tablet.printAll(pg);
      tablet.paint(pg);

      pg.dispose();
      pj.end();
      
      setCursor (c);
    }
    else if (object == openCompareItem)
    {
      String filename = getFilename ("Open Compare Map", "map", FileDialog.LOAD);
      if (filename == null)
	return;
      tablet.readCompare (filename);
    }
    else if (object == saveItem)
    {
      String filename = getFilename ("Save","map", FileDialog.SAVE);
      if (filename == null)
	return;
      tablet.toFile (filename);
      setTitle (mapFilename = filename);
    }
    else if (object == quitItem)
    {
      System.exit (0);
    }
    else if (object == selectAllItem)
    {
      tablet.selectAll ();
    }
    else if (object == selectHostsItem)
    {
      tablet.selectHosts ();
    }
    else if (object == selectSwitchesItem)
    {
      tablet.selectSwitches ();
    }
    else if (object == switch8Button)
    {
      tablet.newSwitch (false, 8);
    }
    else if (object == switch16Button)
    {
      tablet.newSwitch (false, 16);
    }
    else if (object == hostButton)
    {
      tablet.newHost(false);
    }
    else if (object == copyButton)
    {
      tablet.duplicate();
    }
    else if (object == levelButton)
    { 
      tablet.levels (scrollpane.getViewportSize());
    }
    else if (object == treeButton)
    { 
      tablet.tree (scrollpane.getViewportSize());
    }
    else if (object == compareNowButton)
    {
      tablet.compareNow();
    }
    else if (object == circleButton)
    {
      tablet.circle (scrollpane.getViewportSize());
    }
    else if (object == runButton)
    {
      runSimulation ();
    }
    
    tablet.requestFocus();
  }
  private void runSimulation ()
  {
      
    Cursor c = getCursor ();
    setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));
      
    boolean computeRoutes = true;

    String basename = mapFilename == null? "temp" : mapFilename;
    if (basename.endsWith(".map"))
    {
      int cutoff = basename.lastIndexOf(".map");
      basename = basename.substring(0,cutoff);
    }

    String mf = basename + ".map.save";
    String rf;
    String of = basename + ".sim";
    String hf = basename + ".hist";
    String selectedSwitches;
    String routerCmd;
    String simCmd;
    
    switch(optionPanel.routingChoice.getSelectedIndex())
    {
      case 0:
	rf = basename + ".sp_routes";
	routerCmd = "simple_routes ";
	routerCmd += mf + " ";
	routerCmd += rf;
	routerCmd += " -route-args -shortest-path";
	break;
      case 1:
	rf = basename + ".s_routes";
	routerCmd = "simple_routes ";
	routerCmd += mf + " ";
	routerCmd += rf;
	routerCmd += " -route-args ";

	selectedSwitches = tablet.getSelectedSwitchesString();	
	if (selectedSwitches!=null && !selectedSwitches.equals("0"))
	  routerCmd += "-roots " + selectedSwitches + " ";

	break;
      case 2:
      default:
	rf = basename + ".d_routes";
	routerCmd = "dijkstra_routes ";
	routerCmd += mf + " ";
	routerCmd += rf;
	routerCmd += " -route-args -use-node-numbers ";
	break;
      case 3:
	rf = basename + ".d_routes";
	routerCmd = "dijkstra_routes ";
	routerCmd += mf + " ";
	routerCmd += rf;
	routerCmd += " -route-args -bfs-node-number ";

	selectedSwitches = tablet.getSelectedSwitchesString();	
	if (selectedSwitches==null || selectedSwitches.equals("0"))
	{
	  setError("Select BFS root first");
	  setCursor (c);
	  return;
	}
	routerCmd += selectedSwitches + " ";
	break;
      case 4:
	rf = basename + ".d_routes";
	routerCmd = "dijkstra_routes ";
	routerCmd += mf + " ";
	routerCmd += rf;
	routerCmd += " -route-args -bottom-up-node-number ";
	break;
      case 5:
	rf = basename + ".d_routes";
	routerCmd = "dijkstra_routes ";
	routerCmd += mf + " ";
	routerCmd += rf;
	routerCmd += " -route-args -use-edge-numbers ";
	break;
      case 6:
	rf = basename + ".f_routes";
	routerCmd = "force_routes ";
	routerCmd += mf + " ";
	routerCmd += rf;
	routerCmd += " -route-args ";
	break;
    }

    if (optionPanel.prioritySubnetCheckbox.getState() == true)
      routerCmd += " -split 2";

    simCmd = "simple_simulator ";
    simCmd += "-simulator-args ";      
    simCmd += "-map-file " + mf + " ";
    simCmd += "-route-file " + rf + " ";
    simCmd += "-out-file " + of + " ";
    simCmd += "-num-packets " + optionPanel.totalSlider.getValue() + " ";
    simCmd += "-switch-in-size " + optionPanel.inSizeSlider.getValue () + " ";
    simCmd += "-switch-out-size " + optionPanel.outSizeSlider.getValue () + " ";    

    simCmd += "-simulation-args ";
    simCmd += "-packet-length " + optionPanel.sizeSlider.getValue() + " ";      
    simCmd += "-mean-delay " + optionPanel.delaySlider.getValue() + " ";      

    if (optionPanel.sendAcksCheckbox.getState () == true)
      simCmd += " -send-acks ";

    simCmd += "-high-priority " +
    optionPanel.prioritySlider.getValue() + " ";

    if (optionPanel.selfSendCheckbox.getState() == true)
      simCmd += "-self-send ";

    if (optionPanel.histogramCheckbox.getState() == true)
      simCmd += "-histogram-file "+hf+" ";

    simCmd += "-route-args";

    /*
      options += optionPanel.trafficChoice.getSelectedIndex() + " ";

      options += optionPanel.randomSizeCheckbox.getState () ? "1 " : "0 ";
      options += optionPanel.delaySlider.getValue() + " ";
      options += optionPanel.randomDelayCheckbox.getState () ? "1 " : "0 ";
      */

    setError ("Writing map file");

    tablet.toFile(mf);

    setError ("Calculating routes");
      
    if (exec (routerCmd))
    {

      setError ("Running simulation");

      if (exec (simCmd))
      {
	boolean routesError = false;

	if (optionPanel.readRoutesCheckbox.getState() == true)
	{
	  try {
	    setError ("Reading routes");
	    
	    tablet.readRoutes (rf);
	  }
	  catch(Exception exc)
	  {
	    System.out.println(exc);
	    routesError = true;
	  }
	}
	  
	setError ("Reading simulation data");
	  
	if (tablet.fromSimulation (of))
	  setError ("Deadlock detected");
	else
	{
	  if (routesError)
	    setError ("Couldn't read routes file.");
	  else
	  {
	    setError ("");

	    if (optionPanel.histogramCheckbox.getState() == true)
	    {
	      histogram.read(hf);
	    }
	  }
	}
      }
    }
    setCursor (c);
    repaint();
  }

  public void update (Graphics g)
  {
    paint (g);
  }

  public void run()
  {
    frame.invalidate();
    for (;;)
    {
      if (mapFilename != null)
	tablet.refreshFromFile (mapFilename);
      try
      {
	if (refreshTime != 0)
	  Thread.sleep (refreshTime);
      }
      catch (Exception ugly)
      {
      }
    }
  }
  private class ProcessFlag
  {
    public boolean value = false;
    public String error = null;
  }
  private class ProcessWaiter extends Thread
  {
    ProcessFlag mDone;
    Process mP;

    ProcessWaiter(Process p, ProcessFlag done)
    {
      mDone = done;
      mDone.value = false;
      mP = p;
    }

    public void run ()
    {
      try {
	mP.waitFor();
	mDone.value = true;
      }
      catch (Exception ex)
      {
	mDone.error = ex.toString();
	mDone.value = true;
      }
    }
  }
  
  private boolean exec (String s)
  {
    Runtime r = Runtime.getRuntime();
    Process p;
    ProcessFlag doneFlag;
    ProcessWaiter waiter;
    int b;
    
    s =  "../tools/" + arch + "/" + s;

    try {
      System.out.println (s);
      
      p = r.exec (s);
      doneFlag = new ProcessFlag();
      waiter = new ProcessWaiter(p, doneFlag);
      waiter.start();
      
      InputStream f = p.getInputStream();
      
      while(doneFlag.value==false)
      {
	while ((b = f.read ()) >= 0)
	  System.out.write (b);
	Thread.sleep(200);
      }
      
      if (p.exitValue() != 0)
      {
	setError ("subprocess error. (see console.)");
	System.out.println ("error executing " + s);
      }
      
      while ((b = f.read ()) >= 0)
	System.out.write (b);
      f.close();
      
      if (doneFlag.error != null)
      {
	setError (doneFlag.error);
	return false;
      }
      
      return p.exitValue() == 0;
    }
    catch (Exception ex)
    {
      setError (ex.toString());
      return false;
    }
  }
public void windowActivated (WindowEvent e)
  {
  }
  public void windowClosed (WindowEvent e)
  {
  }
  public void windowClosing (WindowEvent e)
  {
    System.exit (0);
  }
  public void windowDeactivated (WindowEvent e)
  {
  }
  public void windowDeiconified (WindowEvent e)
  {
  }
  public void windowIconified (WindowEvent e)
  {
  }
  public void windowOpened (WindowEvent e)
  {
  }
  public static void main (String[] arguments)
  {
    merlin m = new merlin (arguments);
  }
}



