/*
  SuperSlider.java
  Merlin
  (c) 1998 Myricom, Inc.
  dmazzoni@myri.com (Dominic Mazzoni)
*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

public class SuperSlider extends Panel implements KeyListener, AdjustmentListener
{
  int min;
  int max;
  int value;
  int displayValue;

  boolean log;
  int base;

  private class Widebar extends Scrollbar
  {
    public Widebar (int value, int min, int max)
    {
      super (Scrollbar.HORIZONTAL, value, 1, min, max + 1);
    }
    public Dimension getSize ()
    {
      return new Dimension (150, 10);
    }
    public Dimension getPreferredSize ()
    {
      return getSize ();
    }
    public Dimension getMinSize ()
    {
      return getSize ();
    }
  };

  Widebar slider;
  TextField text;
  Label label;

  public SuperSlider(String title, int min, int max, int value)
  {
    this.min = min;
    this.max = max;
    this.value = value;
    this.log = false;
    this.base = 10;
    
    BorderLayout layout = new BorderLayout ();
    this.setLayout (layout);
    
    slider = new Widebar (value,  min, max);
    slider.addAdjustmentListener (this);
    this.add ("West",slider);
    
    label = new Label (title);
    this.add ("Center",label);
    
    if (log)
    {
      if (value==0)
	displayValue = 0;
      else
	displayValue = (int) Math.pow ((double) base,(double)(value - 1));
    }
    else  displayValue = value;
    
    text = new TextField (Integer.toString(displayValue), 10);
    text.addKeyListener(this);
    this.add ("East",text);
  }
  public void SetLogarithmic (boolean logarithmic, int base)
  {
    this.log = logarithmic;
    this.base = base;
    
    if (logarithmic)
    {
      if (value==0)
	displayValue = 0;
      else
	displayValue = (int)Math.pow((double)base,(double)(value-1));
    }
    else displayValue = value;
    text.setText(Integer.toString(displayValue));
  }
  public int getValue()
  {
    return displayValue;
  }
  public void keyPressed(KeyEvent e) {}
  public void keyTyped(KeyEvent e) {}
  
  public void keyReleased(KeyEvent e)
  {
    // The text field got edited
    
    String s = text.getText();
    try {
      displayValue = Integer.parseInt(s);
      
      if (log)
      {
	if (displayValue<=0)
	  value = 0;
	else
	  value = 1+(int)(0.5+(Math.log((double)displayValue) / 
			       Math.log((double)base)));
	if (value>max)
	  value = max;
      }
      else
      {
	value = displayValue;
	if (value>max)
	  value = max;
	if (value<min)
	  value = min;
      }
      
      slider.setValue(value);
    }
    catch (Exception ex)
    {
    }
  }
  public void adjustmentValueChanged (AdjustmentEvent e)
  { 
    // The slider got moved
    
    value = slider.getValue();
    if (log)
    {
      if (value==0)
	displayValue = 0;
      else
	displayValue = (int)Math.pow((double)base,(double)(value-1));
    }
    else
      displayValue = value;
    
    text.setText(Integer.toString(displayValue));
  }
}

