import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

class SelectFrame extends Frame implements ActionListener
{
  private Button closeButton;
  private Button routeButton;
  private Button selectButton;
  private TextArea text;
  SelectFrameListener listener;
  
  public SelectFrame (Font font, SelectFrameListener listener)
  {
    setFont (font);
    this.listener = listener;
    
    Panel dialog = new Panel();
    add (dialog);
    dialog.setLayout (new BorderLayout ());
    Panel panel = new Panel ();
    panel.setLayout (new FlowLayout());
    dialog.add ("West", panel);
    Panel bottom = new Panel ();
    bottom.setLayout (new FlowLayout (FlowLayout.LEFT));
    dialog.add ("South", bottom);
    
    panel.add (text = new TextArea (10,20));
    
    bottom.add (selectButton = new Button ("Select"));
    bottom.add (routeButton = new Button ("Show Routes"));
    bottom.add (closeButton = new Button ("Close"));

    selectButton.addActionListener (this);
    routeButton.addActionListener (this);
    closeButton.addActionListener (this);

    setSize (200, 270);
    this.setTitle ("Select Hosts");
   }
    
  public void actionPerformed (ActionEvent e)
  {
    Object object = e.getSource ();
    
    if (object == closeButton)
    {
      setVisible (false);
      return;
    }
    String s = text.getText ();
    String names[] = getNames (s);
    if (names == null || names.length == 0)
      return;
    
    listener.selectFrameCallback (names, object == routeButton);
  }

  String [] getNames (String s)
  {
    if (s == null || s.equals (""))
      return null;
    
    StringTokenizer t = new StringTokenizer (s,"\n");
    String names [] = new String [t.countTokens()];

    for (int i = 0; i < names.length; i++)
      names[i] = t.nextToken();
    return names;
  }
}
  

