/*
  EasyFileDialog.java
  Merlin
  (c) 1998 Myricom, Inc.
  dmazzoni@myri.com (Dominic Mazzoni)
*/

import java.awt.*;
import java.awt.event.*;

class EasyFileDialog extends Dialog implements ActionListener
{
  private Label label;
  private Button okButton;
  private Button cancelButton;
  private TextField text;
  
  private String fname;
  
  boolean yes;

  public String getFile(String title)
  {
    this.setTitle(title);
    label.setText(title);
    
    label.setSize(400,20);
    
    this.show();
    
    if (yes)
      return text.getText();
    else
      return null;
  }

  public EasyFileDialog (Frame parent, Font f)
  {
    super(parent,"",true);
    
    setFont (f);
    setBackground (Color.lightGray);
    
    fname = System.getProperty("user.dir");
    
    Panel panel = new Panel();
    this.add (panel);
    
    GridBagLayout gridbag = new GridBagLayout ();
    panel.setLayout (gridbag);
    
    Insets border = new Insets(3,3,3,3);
    
    GridBagConstraints across = new GridBagConstraints();
    across.gridx = 0;
    across.gridwidth = GridBagConstraints.REMAINDER;
    across.anchor = GridBagConstraints.WEST;
    across.insets = border;
    
    GridBagConstraints left = new GridBagConstraints();
    left.gridx = 0;
    left.anchor = GridBagConstraints.WEST;
    left.insets = border;
    
    GridBagConstraints right = new GridBagConstraints();
    right.gridwidth = GridBagConstraints.REMAINDER;
    right.anchor = GridBagConstraints.WEST;
    right.insets = border;
    
    // Label
    
    label = new Label ("Save routes as...");
    label.setSize(400,20);
    gridbag.setConstraints(label,across);
    panel.add (label);

    // Text field
    
    text = new TextField (fname, 40);
    gridbag.setConstraints(text,across);
    panel.add (text);
    
    // OK button
    
    okButton = new Button ("OK");
    
    panel.add(okButton);
    gridbag.setConstraints(okButton,left);
    panel.add (okButton);
    okButton.addActionListener (this);
    
    // Cancel button
    
    cancelButton = new Button ("Cancel");
    gridbag.setConstraints(cancelButton, right);
    panel.add(cancelButton);
    cancelButton.addActionListener (this);
    
    setSize (500, 180);
  }
  
  public void actionPerformed (ActionEvent e)
  {
    Object object = e.getSource ();
    
    if (object == okButton)
    {
      yes = true;
      setVisible (false);
    }
    
    if (object == cancelButton)
    {
      yes = false;
      setVisible (false);
    }
  }    
}
