/*
  Cloud.java
  Merlyn
  (c) 1997 Myricom, Inc.
  finucane@myri.com (David Finucane)
*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.awt.image.*;
import GraphicsUtil;

class Cloud extends Node
{
  private static Image classImage;
  private Hashtable routes;
  private boolean routeOn = false;
  private int numPorts;
  
  public Cloud (int numPorts, int x, int y, String name)
  {
    super (x, y, name);
    edges = new Edge [numPorts];
    bandwidths = new double [numPorts];

    for (int i = 0; i < numPorts; i++)
      bandwidths [i] = 0;

    routes = new Hashtable ();
    this.numPorts = numPorts;
    
    if (classImage == null)
      classImage = loadImage ("cloud.gif");
    image = classImage;
  }
  public int getNumEdges ()
  {
    return numPorts;
  }  
  public void clearRoutes ()
  {
    routes.clear();
  }
  public void setRoute (Cloud c, int index, Route r)
  {
    if (index == 0)
      setRoute (c, r);
  }
  public void setRoute (Cloud c, Route r)
  {
    routes.put (c, r);
  }
  public Route getRoute (Cloud c)
  {
    return (Route) routes.get (c);
  }
  public Switch getSwitch ()
  {
    return (Switch) edges[0].getOther (this);
  }
  public Point getPoint (int n)
  {
    return new Point (x + image.getWidth (null) / 2,
                      y + image.getHeight (null) / 2);
  }
  public boolean getRouteOn ()
  {
    return routeOn;
  }
  public void setRouteOn (boolean b)
  {
    routeOn = b;
  }
  public boolean toggleRoute (Cloud from)
  {
    routeOn = !routeOn;
    int d = routeOn ? +1 : -1;
    
    Route r = from.getRoute (this);

    if (r == null)
    {
      System.out.println ("no route");
      return false;
    }
    int hops[] = r.getHops();
    int nHops = r.getLength();
    
    Node n = from;
    Edge e = n.getEdge (0);
    
    e.setRouteCount (e.getRouteCount () + d);
    n = e.getOther (n);
    
    for (int i = 0; i < nHops; i++)
    {
      int p = n.getPort (e);
      e = n.getEdge (p + hops[i]);
      e.setRouteCount (e.getRouteCount () + d);
      n = e.getOther(n);
    }
    return true;
  }

  public int getPosition (Edge e)
  {
    return edges[0] == e ? 0 : -1;
  }
  public boolean contains (int x, int y)
  {
    return super.contains (image, x, y);
  }
  public  String getPrefix ()
  {
    return "cloud " + numPorts + " ";
  }
  public String toString ()
  {
    return "cloud " + numPorts + " " + super.toString ();
  }
}
