#include "mapgen.c"

// 8 x 6 grid of switches, each with 8 hosts
// NEW SANDIA CLUSTER
//
// modified torus connections

main()
{
  int x,y,i;
  int xx,yy;
  int ss;
  const int xDim = 8;
  const int yDim = 7;
  const int rack = 8; // hosts per switch
  int xtab[8] = {7,6,5,4,3,2,1,0};  //{0,2,1,3,6,4,7,5};
  int ytab[8] = {0,1,2,3,4,5,6,7};  //{0,2,4,5,3,1,6,7};
  int ho; // host offset

  numSwitches = xDim * yDim;
  numHosts = xDim * yDim * rack;

  numDeadSwitches = 6;
  numDeadHosts = 6*rack;

  numNodes = numSwitches + numHosts;
  node = (struct Node *)malloc(numNodes*sizeof(struct Node));
  for(i=0; i<numNodes; i++)
    Init(&node[i], i);

  ho = xDim*yDim;

  // kill 6 of 8 in bottom
  for(x=2; x<xDim; x++)
  {
    ss = (yDim-1)*xDim+x;
    node[ss].type = -1;
    for(i=0; i<rack; i++)
      node[ho+(ss)*rack+i].type = -1;
  }

  for(x=0; x<xDim; x++)
    for(y=0; y<yDim; y++)
    {
      ss = y*xDim+x;
      if (node[ss].type != -1)
      {
	node[ss].number = y*xDim + x;
	node[ss].x = 110*xtab[x] + 45 - 2*ytab[y] +20*(x%2);
	node[ss].y = 86*ytab[y] + 80 + 10*(xtab[x]/2);
	node[ss].ports = 16;
	
	sprintf(node[ss].name,
		"myrinet-%d.su-%s%d",
		x%2,
		(((y*xDim + x)/2)<10?"0":""),
		(y*xDim + x)/2);

	node[ss].gx = x;
	node[ss].gy = y;

	for(i=0; i<rack; i++)
	{
	  node[ho+(ss)*rack+i].type = 1; // host
	  node[ho+(ss)*rack+i].x = 110*xtab[x] + 8*i + 30 - 2*ytab[y] +20*(x%2);
	  node[ho+(ss)*rack+i].y = 86*ytab[y] + 40 + 10*(xtab[x]/2);
	  
	  sprintf(node[ho+(ss)*rack+i].name,
		  "compute-%d.su-%s%d",
		  (x%2)*8+i,
		  (((y*xDim + x)/2)<10?"0":""),
		  (y*xDim + x)/2);
	  
	  ConnectPorts(ho+(ss)*rack+i,0,ss,i);
	}
      }
    }

  for(y=0; y<yDim; y++)
    for(x=0; x<xDim; x+=2)
      for(i=1; i<xDim; i+=2)
	ConnectNodesMinPN(y*xDim+x,y*xDim+i,8);
  
  for(x=0; x<xDim; x++)
    for(y=0; y<yDim; y+=2)
      for(i=1; i<yDim; i+=2)
	ConnectNodesMinPN(y*xDim+x,i*xDim+x,12);

  //  OutputGuide();
  Output();
}
