/*
  sm_Switch.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef sm_Switch_h
#define sm_Switch_h

#include "sm_Node.h"
#include "sm_Port.h"

class sm_Switch : public sm_Node
{
  public:
  enum constants
  {
    NUM_PORTS = 16
  };

  private:
  sm_Port inputs [NUM_PORTS];
  sm_Port outputs [NUM_PORTS];
  int definePorts (char*s);
  static int numSwitches;
  int id;
  
  public:
  sm_Switch (char*name, char*type, int inSize, int outSize, int timeForByte);
  
  virtual int isNull ();
  virtual int getNodeType ();

  virtual int getId ();
  
  virtual int getMaxNodes ();
  virtual int setOption (char*option, char*value);

  virtual sm_Port*getInput (int i);
  virtual sm_Port*getOutput (int i);
  virtual void definePort (int i, int inSize, int outSize, int timeForByte);
  virtual void makePort (int i, int inSize, int outSize, int timeForByte);
  virtual void call (sm_EventList*list, int type, long data);  
};

#endif /*sm_Switch_h*/
