/*
  sm_Port.c
  map tools
  finucane@myri.com (David Finucane)
*/


#include "insist.h"
#include "sm_Port.h"

sm_Port::sm_Port ()
{
}

sm_Port::sm_Port (sm_Node*node, int port, int size, int latency, int timeForByte)
{
  this->port = port;
  this->node = node;
  head = tail = 0;
  packet = 0;
  next = 0;
  numPackets = 0;
  
  timeUtilized = 0;
  nextInLine = 0;
  
  define (size, latency, timeForByte);
}

void sm_Port::define (int size, int latency, int timeForByte)
{
  insist (this);
  insist (size > 0 && latency >= 0 &&  timeForByte > 0);
  this->size = size;
  this->latency = latency;
  this->timeForByte = timeForByte;
  exception: return;
}

void sm_Port::setNextInLine (sm_Packet*nextInLine)
{
  insist (this);
  this->nextInLine = nextInLine;
  exception: return;
}
sm_Packet* sm_Port::getNextInLine ()
{
  insist (this);
  return nextInLine;
  exception: return 0;
}
void sm_Port::call (sm_EventList* /*list*/, int /*type*/, long data)
{
  insist (this);

  perr ("%x called\n", this);
  perr ("%x byte count: bytes = %d\n", this, (int)data);

  timeUtilized += data * timeForByte;
  numPackets++;
  
  exception: return;
}
int sm_Port::getTimeForByte ()
{
  insist (this);
  return timeForByte;
  exception: return 0;
}
int sm_Port::getAddedLatency ()
{
  insist (this);
  return latency;
  exception: return 0;
}
void sm_Port::setNext (sm_Port*next)
{
  insist (this);
  this->next = next;
  exception: return;
}
sm_Port*sm_Port::getNext ()
{
  insist (this);
  return next;
  exception: return 0;
}
void sm_Port::setPacket (sm_Packet*packet)
{
  insist (this);
  perr ("nport %x setpacket %x \n", this, packet);
  this->packet = packet;
  exception: return;
}
sm_Packet*sm_Port::getPacket ()
{
  insist (this);
  return packet;
  exception: return 0;
}
int sm_Port::getSize ()
{
  insist (this);
  return size;
  exception: return 0;
}
int sm_Port::getPort ()
{
  insist (this);
  return port;
  exception: return 0;
}
sm_Node*sm_Port::getNode ()
{
  insist (this);
  return node;
  exception: return 0;
}
sm_Time sm_Port::getTimeUtilized()
{
  insist (this);
  return timeUtilized;
  exception: return 0;
}

int sm_Port::getNumPackets ()
{
  insist (this);
  return numPackets;
  exception: return 0;
}
