/*
  sm_Null.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include "insist.h"
#include "mt_Network.h"
#include "sm_Null.h"
#include "sm_Packet.h"

sm_Null::sm_Null (char*name, char*type) : sm_Node (name, type)
{
  int b = mt_Network::MTU + mt_Route::MAX_ROUTE;
  definePort (0, b, b, 7);
}

int sm_Null::definePorts ()
{
  insist (0);
  exception: return 0;
}

int sm_Null::isNull ()
{
  return 1;
}

int sm_Null::getNodeType ()
{
  return mt_Node::HOST;
}
  
int sm_Null::getMaxNodes ()
{
  return 0;
}


sm_Port*sm_Null::getInput (int p)
{
  insist (this);
  insist (!p);

  return &input;

  exception: return 0;
}

sm_Port*sm_Null::getOutput (int p)
{
  insist (this);
  
  return p ? 0 : &output;

  exception: return 0;
}

void sm_Null::definePort (int p, int inSize, int outSize, int timeForByte)
{
  insist (!p);
  insist (inSize > 0 && outSize > 0);

  input  = sm_Port (this, p, inSize, 0, timeForByte);
  output = sm_Port (this, p, outSize, 0, timeForByte);
  exception: return;
}


void sm_Null::call (sm_EventList*list, int type, long data)
{
  insist (this);
  insist (list);
  
  sm_Packet*p;
  p = (sm_Packet*) data;

  switch (type)
  {
    case sm_EventList::ARRIVAL:
      insist (p && p->getTailPort () == &input && p->getHeadPort () == &input);
      insist (p->canDie ());
      numDrops++;
      delete p;
      break;
    default: break;
  }
  exception: return;
}
