/*
  sm_EventList.h
  map tools
  finucane@myri.com (David Finucane)
  dmazzoni@myri.com (Dominic Mazzoni)
*/

#ifndef sm_EventList_h
#define sm_EventList_h

#include "mt_Component.h"

typedef mt_Int64 sm_Time;

class sm_Callable;
class sm_Simulator;

class sm_Event : public mt_Component
{
  public:
  int type;
  sm_Time time;
  sm_Callable*callable;
  long data;

  // index in event priority queue
  int qIndex;

  // position in the local Callable's list of messages
  sm_Event *cPrev;
  sm_Event *cNext;
  
  sm_Event ();
  ~sm_Event ();
  sm_Event (int type, sm_Time time, sm_Callable*callable, long data);
};

class sm_EventList : public mt_Component
{
  private:

  sm_Event **queue;
  int queueSize;
  int queueMaxSize;
  sm_Time time;
  int movements;
  
  public:
  
  enum
  {
    MICROS_PER_TICK = 1000
  };
  
  enum eventType
  {
    ARRIVAL = 0,
    DEPARTURE,
    SEND,
    MOVE,
    UNBLOCK,
    TIMEOUT,
    RECEIVE,
    TO_HOST,
    TO_NETWORK,
    ANY,
    NUM_EVENTS
  };

  int print ();

  private:
  int eventCounters [NUM_EVENTS];

  public:
  sm_EventList (sm_Simulator *simulator);
  ~sm_EventList();
  int processEvent ();
  int getQueueSize ();
  int inspect (char*s);
  void reportMove ();
  
  int check();
  void addEvent (sm_Event *e);
  void extractEvent (sm_Event *e);
  sm_Time getCurrentTime ();
  sm_Simulator *getSimulator();

  private:

  sm_Simulator *simulator;

  void growQueue ();
  void swap (int index1, int index2);
  void trickle_up (int index);
  void trickle_down (int index);
};

#endif /*sm_EventList_h*/
