/*
  mt_htonl.h
  map tools
  finucane@myri.com
*/

#ifndef mt_htonl_h
#define mt_htonl_h

#if defined (MT_intel_nt) || defined (MT_intel_ms) || defined (MT_intel_linux) || defined (MT_intel_solaris) || defined (MT_intel_freebsd) || defined (MT_dec_linux)

inline int mt_htonl (int n)
{
  unsigned char*s = (unsigned char *)&n;
  return (int)(s[0] << 24 | s[1] << 16 | s[2] << 8 | s[3]);
}
inline short mt_htons (short n)
{
  unsigned char*s = (unsigned char*)&n;
  return (short)(s[0] << 8 | s[1]);
}

#elif defined (MT_sparc_solaris) || defined (MT_ppc_vxWorks)

#define mt_htonl(n) n
#define mt_htons(n) n

#else

#include "gm_roster.h"

#include "gm.h"
#define mt_htonl(n) __gm_hton_u32 (n)
#define mt_htons(n) __gm_hton_u16 (n)


#endif

#endif /*mt_htonl_h*/
