/*
  mt_Tokenizer.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "insist.h"

#include "mt_FileReader.h"
#include "mt_Tokenizer.h"

mt_Token::mt_Token (char*stream, const char*whitespace)
{
  insist (this);
  insist (stream && whitespace);

  lines = 1;
  buffer = this->stream = stream;
  this->whitespace = whitespace;
  token = 0;
  quoted = 0;
    
  exception:return;
}


char*mt_Token::getNext()
{
  insist (this);
  insist (buffer && whitespace);
    
  if (!stream || !*stream)
    return token = stream = 0;

  char*h;
  char*t;
      
  while (*stream && (h = strchr (const_cast<char*>(whitespace),*stream)))
/* while (*stream && (h = strchr ((char *)whitespace,*stream))) */
  {
    if (*h == '\n')
      lines ++;
    stream++;
  }
  if (!*stream)
    return token = stream = 0;
    
  if ((quoted = (*stream == '\"')))
  {
    char*t =  strchr (stream + 1, '\"');
    if (!t)
      return token = 0;
    *t = 0;
    char*r = stream;
    stream += strlen (stream) + 1;
    return token = r + 1;
  }

  t = strpbrk (stream + 1, whitespace);
  if (t)
  {
    if (*t == '\n')
      lines++;
      
    *t = 0;
    char*r = stream;
    stream += strlen (stream) + 1;
    return token = r;
  }
  else
  {
    token = stream;
    stream = 0;
    return token;
  }
  exception: return token = stream = 0;
}


char*mt_Token::getWord()
{
  insist (this);
  return token;
  exception: return 0;
}


int mt_Token::getInteger()
{
  insist (this);
  if (token)
  {
    int i;
    int r = sscanf (token, "%i", &i);
    insist (r == 1);
    return i;
  }
  
  exception: return 0;
}


int mt_Token::isInteger ()
{
  insist (this);
  
  if (quoted || !token)
    return 0;
    
  char*s;
  s = token;

  if (*s && *s == '+' || *s == '-')
    s++;
    
  if (strlen (s) > 2 && *s == '0' && tolower (s[1]) == 'x')
    s+=2;
 
  for (;*s; s++)
    if (!isdigit (*s) && !isxdigit (*s))
      return 0;
  return 1;
  exception: return 0;
}


int mt_Token::isWord()
{
  insist (this);
  return quoted || !token || *token == 0 || ! isInteger();
  exception: return 0;
}


int mt_Token::getLineNumber()
{
  insist (this);
  return lines;
  exception: return 0;
}


mt_Tokenizer::mt_Tokenizer (FILE*fp, const char*whitespace, int maxLine, const char*commentChars)
{
  insist (this);
  
  tokens = 0;
  reader = 0;
  insist (fp && whitespace && maxLine > 0);
  reader = new mt_FileReader (fp, maxLine, commentChars);
  insist (reader);
  strncpy (this->whitespace, whitespace, FORMAT_LEN);
  exception: return;
}


mt_Tokenizer::mt_Tokenizer (char*filename, const char*whitespace, int maxLine, const char*commentChars)
{
  insist (this);
  
  tokens = 0;
  reader = new mt_FileReader (filename, maxLine, commentChars);
  insist (reader);
  strncpy (this->whitespace, whitespace, FORMAT_LEN);
  exception: return;
}


mt_Tokenizer::mt_Tokenizer (char*s, const char*whitespace)
{
  insist (this);
  
  reader = 0;
  tokens = new mt_Token (s, whitespace);
  insist (tokens);
  exception: return;
}


mt_Tokenizer::~mt_Tokenizer ()
{
  if (tokens)
    delete tokens;
  if (reader)
    delete reader;
  tokens = 0;
  reader = 0;
}


char*mt_Tokenizer::getNext ()
{
  insist (this);
  
  char*s,*c;
  
  while (!tokens || !(c = tokens->getNext ()))
  {
    if (!reader || !(s = reader->readLine ()))
    {
      if (tokens)
	delete tokens;
      tokens = 0;
      return 0;
    }
      
    if (tokens)
      delete tokens;
    tokens = new mt_Token (s, whitespace);
    insist (tokens);
  }
  return c;
  exception: return 0;
}


int mt_Tokenizer::isWord ()
{
  insist (this); 
  return tokens && tokens->isWord();
  exception: return 0;
}


int mt_Tokenizer::getLineNumber ()
{
  insist (this);
  return reader->getLineNumber();
  exception: return 0;
}


int mt_Tokenizer::isInteger ()
{
  insist (this);
  return tokens && tokens->isInteger();
  exception: return 0;
}


int mt_Tokenizer::getInteger ()
{
  insist (this); 
  if (tokens)
    return tokens->getInteger();
  exception: return 0;
  
}

int mt_Tokenizer::equals (const char*s)
{
  insist (this);
  insist (s);
  return tokens && !strcmp (tokens->getWord (), s);
  exception: return 0;
}

char*mt_Tokenizer::getWord ()
{
  insist (this);
  return tokens ? tokens->getWord() : 0;
  exception: return 0;
}
