/*
  mt_Switch.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_Switch_h
#define mt_Switch_h

#include "mt_Node.h"

class mt_Switch : public mt_Node
{
  public:
  enum
  {
    NUM_PORTS = 16
  };
  
  private:
  mt_Node*nodes [NUM_PORTS];
  char opposites [NUM_PORTS];

  public:
  mt_Switch (char*name, char*type);
  virtual int getNodeType ();
  virtual int getMaxNodes ();
  virtual mt_Node*getNode (int p);
  virtual int getOpposite (int p);
  virtual void connect (int p, int o, mt_Node*n);
  virtual void disconnect (int p);
};
  
#endif /*mt_Switch_h*/
