/*
  mt_RouteTable.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_RouteTable_h
#define mt_RouteTable_h

#include <stdio.h>
#include "mt_Route.h"
#include "mt_Graph.h"
#include "mt_Args.h"
#include "mt_Calculator.h"

class mt_RouteTable : public mt_Component
{
  private:
  char**byteArrays;
  char**routes;
  int isFromFile;
  
  int numHosts;
  int maxRoutes;
  
  public:
  mt_RouteTable ();
  ~mt_RouteTable ();

  int fromCalculator (mt_Calculator*calculator, mt_Graph*graph);
  int fromFile (char*filename, mt_Graph*graph);

  int getMaxRoutes();
  int getNumRoutes(int from, int to);
  int getRoute (int from, int to, int index, mt_Route*route);
  int check (mt_Graph*graph);
};


#endif /*mt_RouteTable_h*/
