/*
  mt_RouteFile.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_RouteFile_h
#define mt_RouteFile_h

#include <stdio.h>
#include "mt_Node.h"
#include "mt_Route.h"
#include "mt_FileReader.h"
#include "mt_Tokenizer.h"
#include "mt_File.h"

class mt_Calculator;

class mt_RouteFile : public mt_File
{
  private:
  mt_FileReader*reader;
  int numHosts;
  int maxRoutes;
  int numRoutes;
  int curRoute;
  int readFromLine (char*from, mt_Token*tokens, int*numRoutes, int*numBytes, int line);
  int readToLine (char*to, mt_Route *route, mt_Token*tokens, int line);

  public:
  mt_RouteFile (const char*filename, int mode);
  mt_RouteFile (FILE*fp);  
  ~mt_RouteFile ();

  static int writeLimits (FILE*fp, int numHosts, int maxRoutes);
  static int writeFromLine (FILE*fp, char*name, int numRoutes, int numBytes);
  static int writeToLine (FILE*fp, char*name, mt_Route*route);
  int write (mt_Calculator*calculator);
  int readHeader (int*numHosts, int*maxRoutes);
  int readFromLine (char*from, int*numRoutes, int*numBytes);
  int readToLine (char*to, mt_Route *route);
};


#endif /*mt_RouteFile_h*/
