/*
  mt_Route.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_Route_h
#define mt_Route_h

#include "mt_Component.h"


class mt_RouteStorage : public mt_Component
{
  private:
  enum
  {
    SMALL_ROUTE = 256,
    MAX_ROUTE = 4192
  };
  
  protected:
  int size;
  char _hops [SMALL_ROUTE];
  char*hops;
  static char buffer [MAX_ROUTE * 4];

  public:
  mt_RouteStorage (mt_RouteStorage&r);
  mt_RouteStorage (int size);
  ~mt_RouteStorage ();
};

class mt_Route : public mt_RouteStorage
{
  public:
  enum
  {
    MAX_ROUTE = 256, /*mult of 4 for alignment*/
    MIN_HOP = -32,
    MAX_HOP = 32,
    SWITCH_ID = MAX_HOP + 1,
    EVIL_HOP = 0xa0
  };
  private:
  int length;
  
  public:
  mt_Route (const mt_Route&r);
  mt_Route&operator = (const mt_Route&r);
  mt_Route (int size = MAX_ROUTE);
  mt_Route (char*s, int length);
  mt_Route (int c, mt_Route*r);
  mt_Route (mt_Route*a, mt_Route*b);
  mt_Route (mt_Route*a, int n, mt_Route*b);
  mt_Route (mt_Route*a, int n1, int n2, int n3, mt_Route*b);
  mt_Route (mt_Route*r, int c);
  mt_Route (mt_Route*r, int a, int b);
  mt_Route (mt_Route*r, int a, int b, int c);
  int fromBytes (char*s, int length);
  int getLength ();
  void copyOut (char*a);
  char*getHops ();
  void append (int c);
  void append (mt_Route*r);
  void empty ();
  char*toString (char*s);
  char*toString ();
  char*press (char*p);
  static char*physical (char*o, char*n, int length);
  static char*logical (char*o, char*n, int length);
  void invert ();
  int equals (mt_Route*r);
  int getLastHop ();
};



#endif /*mt_Route_h*/
