/*
  mt_Route.c
  map tools
  finucane@myri.com (David Finucane)
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "insist.h"
#include "mt_Route.h"

char mt_RouteStorage::buffer [MAX_ROUTE * 4];

mt_RouteStorage::mt_RouteStorage (mt_RouteStorage&)
{
  insist (0);
  exception:;
}

mt_RouteStorage::mt_RouteStorage (int size)
{
  insist (size <= MAX_ROUTE);

  this->size = size;
  
  if (size <= SMALL_ROUTE)
  {
    this->size = SMALL_ROUTE;
    hops = _hops;
  }
  else
  {
    hops = (char*) malloc (size);
    insistp (hops, ("malloc of %d bytes failed", size));
  }
  
  exception:;
}
  
mt_RouteStorage::~mt_RouteStorage ()
{
  insist (this);
  insist ((size <= SMALL_ROUTE && hops == _hops) || (size > SMALL_ROUTE && hops != _hops));

  if (size > SMALL_ROUTE)
  {
    insist (hops && hops != _hops);
    free (hops);
  }
  exception:;
}

mt_Route&mt_Route::operator = (const mt_Route&r)
{
  insist (this);
  fromBytes (r.hops, r.length);

  exception: return *this;;
}

  
mt_Route::mt_Route (const mt_Route&r) : mt_RouteStorage (r.length)
{
  insist (this);
  fromBytes (r.hops, r.length);
  exception: return;
}

mt_Route::mt_Route (int size) : mt_RouteStorage (size)
{
  insist (this);
  length = 0;
  exception: return;
}


mt_Route::mt_Route (char*s, int length) : mt_RouteStorage (length)
{
  fromBytes (s, length);
}

int mt_Route::fromBytes (char*s, int length)
{
  insist (this);
  insist (length <= size);
    
  for (int i = 0; i < length; i++)
  {
    insist (s [i] == (char) EVIL_HOP || (s [i] >= MIN_HOP && s [i] <= MAX_HOP));
    hops[i] = s[i];
  }
  this->length = length;
  return length;
  
  exception: return 0;
}

mt_Route::mt_Route (int c, mt_Route*r) : mt_RouteStorage (r->length + 1)
{
  insist (this);
  insist (r && r->length <= size);
  insist (c == EVIL_HOP || (c >= MIN_HOP && c <= MAX_HOP));
    
  for (int i = 0; i < r->length; i++)
    hops[i + 1] = r->hops[i];
  hops[0] = c;
  length = r->length + 1;
  exception:return;
}

mt_Route::mt_Route (mt_Route*r, int c) : mt_RouteStorage (r->length + 1)
{
  insist (this);
  insist (r);
  insist ((c == EVIL_HOP || c >= MIN_HOP && c <= MAX_HOP) || c == SWITCH_ID);
  
  *this = *r;
  insist (length <= size);
  hops[length] = c;
  length++;
  exception:return;
}

mt_Route::mt_Route (mt_Route*a, mt_Route*b) : mt_RouteStorage (a->length + b->length)
{
  insist (this);
  insist (a && b);
  insist (a->length + b->length <= size);

  length = 0;
  for (int i = 0; i < a->length; i++)
    hops [length++] = a->hops [i];
  for (int i = 0; i < b->length; i++)
    hops [length++] = b->hops [i];
  
  exception:return;
}


mt_Route::mt_Route (mt_Route*a, int n1, mt_Route*b) : mt_RouteStorage (a->length + b->length + 1)
{
  insist (this);
  insist (a && b);
  insist (n1 >= MIN_HOP && n1 <= MAX_HOP);
  
  insist (a->length + 1 + b->length <= size);

  length = 0;
  for (int i = 0; i < a->length; i++)
    hops [length++] = a->hops [i];

  hops [length++] = n1;
  
  for (int i = 0; i < b->length; i++)
    hops [length++] = b->hops [i];
  
  exception:return;
}

mt_Route::mt_Route (mt_Route*a, int n1, int n2, int n3, mt_Route*b) : mt_RouteStorage (a->length + b->length + 3)
{
  insist (this);
  insist (a && b);
  insist (n1 >= MIN_HOP && n1 <= MAX_HOP);
  insist (n2 >= MIN_HOP && n2 <= MAX_HOP);
  insist (n3 >= MIN_HOP && n3 <= MAX_HOP);
  insist (a->length + 3 + b->length <= size);

  length = 0;
  for (int i = 0; i < a->length; i++)
    hops [length++] = a->hops [i];

  hops [length++] = n1;
  hops [length++] = n2;
  hops [length++] = n3;
  
  for (int i = 0; i < b->length; i++)
    hops [length++] = b->hops [i];
  
  exception:return;
}



mt_Route::mt_Route (mt_Route*r, int a, int b) : mt_RouteStorage (r->length + 2)
{
  insist (this);
  insist (r);
  insist (a >= MIN_HOP && a <= MAX_HOP);
  insist (b >= MIN_HOP && b <= MAX_HOP);
  
  *this = *r;
  insist (length + 2 <= size);

  hops[length++] = a;
  hops[length++] = b;
  
  exception:return;
}

mt_Route::mt_Route (mt_Route*r, int a, int b, int c) : mt_RouteStorage (r->length + 3)
{
  insist (this);;
  
  insist (r);
  insist (a >= MIN_HOP && a <= MAX_HOP);
  insist ((b >= MIN_HOP && b <= MAX_HOP) || b == SWITCH_ID);
  insist (c >= MIN_HOP && c <= MAX_HOP);
  
  *this = *r;
  insist (length + 3 <= size);

  hops[length++] = a;
  hops[length++] = b;
  hops[length++] = c;
  
  exception:return;
}


void mt_Route::append (mt_Route*r)
{
  insist (this);
  insist (r);
  insist (length + r->length <= size);

  for (int i = 0; i < r->length; i++)
    hops [length++] = r->hops [i];
  exception:return;
}


void mt_Route::append (int c)
{
  insist (this);
  insist (length <= size -1);
  insist (c >= MIN_HOP && c <= MAX_HOP);
  
  hops[length] = c;
  length++;
  exception:return;
}

void mt_Route::empty ()
{
  insist (this);
  length = 0;
  exception:return;
}

int mt_Route::getLength ()
{
  insist (this);
  return length;
  exception: return 0;
}

char*mt_Route::getHops ()
{
  insist (this);
  return hops;
  exception: return 0;
}

void mt_Route::copyOut (char*a)
{
  insist (this);
  insist (a);
  insist (length >=0 && length <= size);
  
  memcpy (a, hops, length);
  exception: return;
}

char*mt_Route::toString ()
{
  return toString (buffer);
}

char*mt_Route::toString (char*s)
{
  insist (this);
  insist (s);

  char*t;
  t = s;

  *s = 0;
  
  for (int i = 0; i < length; i++)
    s += sprintf (s, "%d%s", hops[i], i == length - 1 ? "" : ",");
  
  return t;
  
  exception: return 0;
}

char*mt_Route::press (char*p)
{
  insist (this);
  insist (p);
  return physical (hops, p, length);
  exception: return 0;
}

char*mt_Route::logical (char*o, char*n, int length)
{
  insistf (o && n && length >= 0);
  
  for (int i = 0; i < length; i++, n++)
  {
    *n = (o[i] & 0x3f);
    if (*n & 0x20)
      *n |= 0xf0;
    
    insistf (*n >= MIN_HOP && *n <= MAX_HOP);
  }
  exception: return n;
}

char*mt_Route::physical (char*o, char*n, int length)
{
  insistf (o && n && length >= 0);
  
  for (int i = 0; i < length; i++, n++)
  {
    if (o [i] == (char) EVIL_HOP)
      continue;
    if (o [i] == SWITCH_ID)
      *n = '\xff';
    else
      *n = (o[i] & '\x3f') | '\x80';
  }
  
  exception: return n;
}
  

void mt_Route::invert ()
{
  mt_Route r (*this);
  
  for (int i = 0; i < length; i++)
    hops [i] = - r.hops [length - 1 - i];
}

int mt_Route::equals (mt_Route*r)
{
  insist (this && r);
  if (length != r->length)
    return 0;
  for (int i = 0; i < length; i++)
    if (hops [i] != r->hops [i])
      return 0;
  return 1;
  exception: return 0;
}

int mt_Route::getLastHop ()
{
  insist (this);
  insist (length);
  return hops [length - 1];
  exception: return 0;
}
