/*
  mt_Queue.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include "mt_Queue.h"

#include "insist.h"

mt_Queue::mt_Queue (int maxItems)
{
  insist (this);
  head = tail = 0;
  numItems = 0;
  this->maxItems = maxItems;
  exception: return;
}

mt_Queue::mt_Queue ()
{
  insist (this);
  head = tail = 0;
  numItems = 0;
  this->maxItems = -1;
  exception: return;
}

void mt_Queue::empty ()
{
  insist (this);
  
  while (head)
    remove (head);
  
  insist (numItems == 0);
  insist (!tail);
  
  exception: return;
}

int mt_Queue::isFull ()
{
  insist (this);
  insist (maxItems == -1 || numItems <= maxItems);
  insist (numItems >= 0);
  
  return maxItems != -1 && numItems == maxItems;  
  exception: return 1;
}

int mt_Queue::isEmpty ()
{
  insist (this);
  insist (maxItems == -1 || numItems <= maxItems);
  insist (numItems >= 0);
  
  return maxItems && numItems == 0;  
  exception: return 1;
}

int mt_Queue::put (mt_Queueable*q)
{
  insist (this);
  insist (q);
  insist (maxItems == -1 || numItems <= maxItems);
  insist (numItems >= 0);
  insist (!isQueued (q));
  insist (q != tail && q != head);
  
  insistx (check ());
  
  if (maxItems != -1 && numItems == maxItems)
    return 0;
  
  if (tail)
  {
    tail->setNext (q);
    q->setPrev (tail);
  }
  else
  {
    insist (!head);
    head = q;
    q->setPrev (0);
  }
  tail = q;
  q->setNext (0);
  
  numItems++;

  insistx (check ());
  
  return 1;
  exception: return 0;
}

mt_Queueable*mt_Queue::get ()
{
  insistx (check ());

  insist (this);
  if (!head)
    return 0;
  
  mt_Queueable*q;
  q = head;
  remove (head);

  insistx (check ());
  
  return q;
  exception: return 0;
}

mt_Queueable*mt_Queue::peek ()
{
  insist (this);
  return head;
  exception: return 0;
}

int mt_Queue::isQueued (mt_Queueable*n)
{
  insist (this);
  insist (n);

  return tail && (n == tail || n->getNext ());

  exception: return 0;
}
  
int mt_Queue::getNumItems ()
{
  insist (this);
  return numItems;
  exception: return 0;
}

int mt_Queue::remove (mt_Queueable*item)
{
  insist (this);
  insist (item);
  insist (numItems > 0);
  
  mt_Queueable*n, *p;

  insistx (check ());
  
  n = item->getNext ();
  p = item->getPrev ();

  if (n)
    n->setPrev (p);
  if (p)
    p->setNext (n);

  if (item == tail)
    tail = p;
  if (item == head)
    head = n;

  item->setNext (0);
  item->setPrev (0);
  
  numItems--;
  insistx (check ());
  
  return 1;
  exception: return 0;
}

int mt_Queue::check ()
{
  mt_Queueable*n, *p;
  mt_Queueable*c = head;

  while (c)
  {    
    n = c->getNext ();
    p = c->getPrev ();

    insist (!n || n->getPrev () == c);
    insist (!p || p->getNext () == c);
    
    c = n;
  }
  return 1;
  exception: return 0;
}
