/*
  mt_Network.h
  map tools
  finucane@myri.com (David Finucane)
*/


#ifndef mt_Network_h
#define mt_Network_h

#include "mt_Simulation.h"
#include "mt_Calculator.h"
#include "mt_Component.h"
#include "mt_Args.h"
#include "mt_Route.h"
#include "mt_Address.h"
#include "mt_Job.h"
#include "mt_Graph.h"

class mt_Network : public mt_Component, public mt_Module
{
  private:
  int aborted;
  
  public:
  enum
  {
    HOSTNAME_LENGTH = 128,
    MTU = 4192
  };
  enum 
  {
    DARN = 0,
    RECEIVE,
    TIMEOUT,
    SEND_DONE
  };
  
  mt_Network ();
  void abort ();
  int isAborted ();
  
  virtual int wait (char**p, int*length) = 0;
  virtual void freePacket (char*p) = 0;
  virtual mt_Graph*getGraph () = 0;
  virtual int getRoute (int from, int to, int index, mt_Route*route) = 0;
  virtual int getNumRoutes (int from, int to) = 0;
  virtual int open (mt_Job*job, mt_Address*address, char*hostname, int*type, int unit, int numReceiveBuffers = 0) = 0;
  virtual void close (mt_Job*job) = 0;
  virtual int send (mt_Job*job, mt_Route*route, char*p, int length) = 0;
  virtual int sendWithPadding (mt_Job*job, mt_Route*route, char*p, int length, int totalLength) = 0;
  virtual void setTimer (mt_Job*job, int microseconds) = 0;
  virtual void clearTimer (mt_Job*job) = 0;
  virtual void setRoute (mt_Job*job, int gmId, mt_Route*route) = 0;
  virtual void setAddress (mt_Job*job, int gmId, mt_Address*address) = 0;
  virtual void setHostname (mt_Job*job, int gmId, char*hostname) = 0;
  virtual void setGmId (mt_Job*job, int gmId) = 0;
  virtual int getGmId (mt_Job*job) = 0;
  virtual mt_Int64 getCurrentTime () = 0;
  virtual void clearRoutes (mt_Job*job) = 0;
  virtual void setLevel (mt_Job*job, int level) = 0;
  virtual int getNumReceiveBuffers () = 0;
  virtual int getReceiveMtu () = 0;
  virtual int enableCrc ();
  virtual int disableCrc ();
  virtual int writeRegister (unsigned int offset, unsigned int value);
  virtual int getSentDoneLength ();
};


extern mt_Network* mt_getNetwork ();

#endif /*mt_Network_h*/
