/*
  mt_Mapper.h
  map tools
  finucane@myri.com
*/

#ifndef mt_Mapper_h
#define mt_Mapper_h

#include "mt_Module.h"
#include "mt_Job.h"
#include "mt_Message.h"
#include "mt_File.h"
#include "mt_HostTable.h"
#include "mt_MapperOptions.h"
#include "mt_Network.h"
#include "mt_Calculator.h"

class mt_Mapper;

#define mt_mapper_c(x) if (options.verbose)printFormat x
#define mt_mapper_v(x) if (options.veryVerbose)printFormat x
#define mt_mapper_w(x) if (options.warnings)printFormat x

typedef void (mt_Mapper::*mt_MessageHandler)(mt_Message*m, int length);

class mt_Mapper : public mt_Job, public mt_NodeFactory
{
  private:
  mt_Calculator*calculator;
  mt_Graph*graph;
  int numAcks;
  int acksPerHost;
  char*acks;
  int*configures;
  mt_Int64*times;
  int lastIncreaseTimeoutsPhase;
  
  int bootHost;
  int phase;
  int aborted;
  int mapVersion;
  
  mt_MessageHandler handlers [mt_Message::NUM_TYPES];
  void handleCloudQueryReply (mt_Message*m, int length);
  void handleConfigureReply (mt_Message*m, int length);
  void setHandler (int type, mt_MessageHandler handler);
  void clearHandler (int type);
  void callMyHandler (int type, mt_Message*m, int length);
  int configureLocal (mt_Graph*graph, int from,  mt_Calculator*calculator);
  int configureRemote (char*acks, int phase, int host, int hostSection, int mapVersion, mt_Address*address,
		       mt_Graph*calculator, mt_ConfigureMessage*message);
  int clearConflict (mt_Node*host, int*phase, int level);
  int clearConflicts (mt_Graph*graph, int mapper, int*phase, int*numClears);
  int addCloudHost (mt_Graph*graph, mt_Node*cloud, mt_CloudHost*ch, int hostType, int p);
  int updateHostTable (char*acks, mt_Calculator*calculator);

  /*obsolete functions to support old config messages*/
  void old_handleConfigureReply (mt_Message*m, int length);
  int old_configure (mt_Graph*graph, int mapVersion, int mapper, int*phase);
  int old_setConfigureMessage (mt_Graph*graph, mt_Address*mapperAddress, mt_Calculator*calculator,
			   mt_OldConfigureMessage*message, int ack, int serial, int from, int start, int stop);
  int old_configureRemote (int ack, char*acks, int acksPerHost, int mapVersion, mt_Address*mapperAddress, mt_Graph*graph,
		       mt_Calculator*calculator, mt_OldConfigureMessage*message);
  int old_startAcks (mt_Graph*graph, int mapper, char*acks, int acksPerHost);
  int old_updateHostTable (char*acks, int acksPerHost, mt_Graph*graph);



  protected:
  mt_MapperOptions options;
  int numUnconfiguredHosts;
  
  class Counters : public mt_Component
  {
    public:
    int receives [mt_Message::NUM_TYPES];
    int sends [mt_Message::NUM_TYPES];
    int badTypes;
    int badLengths;
    int gmIdConflicts;
    int badContents;
    int badPhases;
    int mapVersion;
    int activeMapper;
    int missingSwitches;
    int missingHosts;
    int newSwitches;
    int newHosts;
    int hostCount;
    int switchCount;
    
    Counters ();
    void toFile (FILE*fp);
  };

  Counters counters;
  mt_HostTable*hostTable;
  
  virtual void callHandler (int type, mt_Message*m, int length) = 0;

  int send (mt_Route*route, char*p, int length);
  int wait (int event, int subtype, int phase, char**p, int*length);
  int wait ();
  int wait (int microseconds);
  void writeCounters (char*filename);
  void writeMap (mt_Graph*graph, char*filename);
  void writeHostTable (int makeHosts, char*hostFile);
  int makeHostTable (char*filename, mt_Graph*graph);
  int makeHostTable (int gmId, int hostType, mt_Address*address, char*hostname, int makeHosts, char*filename);
  int isConfigured (mt_Graph*graph, int mapVersion);
  int verifyHost (mt_Route*r, int*phase, int tries, int microseconds, mt_Address*address, mt_Address*mapperAddress,
		  int level, int*mapVersion, char*hostname);
  int verifySwitch (mt_Route*r, int*phase, int tries, int microseconds);

  int verify (mt_Graph*graph, mt_Node*root, int*phase, int mapVersion, mt_Address*address,
	      int level, mt_Route*change, int*isHost, char*hostname);

  int configure (mt_Graph*graph, int mapVersion, int mapper, int*phase);
  int addCloudHosts (mt_Graph*graph, mt_Node*cloud, mt_CloudReplyMessage*m);
  int addCloudHosts (mt_Graph*graph, mt_Node*cloud, mt_CloudQueryReplyMessage*m);

  int queryClouds (mt_Graph*graph, mt_Network*network, int*phase);
  int higherPriority (mt_Address*hisAddress, int hisLevel, mt_Address*myAddress, int myLevel);
  int equalGraphs (mt_Graph*g1, mt_Graph*g2);
  void printVerifyProblem (mt_Graph*graph, mt_Node*root, mt_Route*route, int isHost,
			   char*hostname);
  int formatHostname (char*hostname, int unit);
  int addMissingHosts (mt_Graph*newGraph, mt_Graph*oldGraph);
  int increaseTimeouts (int type, int phase);
  int decreaseTimeouts ();
  int getHostLatency (mt_Route*r, mt_Address*address, int level, int tries, int*phase);
  int getSwitchLatency (mt_Route*r, int tries, int*phase);
  static void printPacket (char*p, int length);
  
  public:
  mt_Mapper (mt_Node*node, mt_Network*network, mt_Calculator*calculator, mt_MapperOptions&options);
  virtual ~mt_Mapper ();
  virtual mt_Node*newNode (int nodeType, char*name, char*type) = 0;
  
  virtual int willWait ();
  virtual void dump (FILE*fp);
  virtual int start () = 0;
  virtual void receive (int event, char*p, int length);
};

extern mt_Mapper*mt_MapperMain ();

#endif /*mt_Mapper_h*/




