/*
  mt_Host.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "insist.h"
#include "mt_Host.h"


int mt_Host::getNodeType ()
{
  return mt_Node::HOST;
}

int mt_Host::getMaxNodes ()
{
  return 1;
}

mt_Host::mt_Host (char*name, char*type) : mt_Node (name, type)
{
  node = 0;
  opposite = -1;
}

void mt_Host::connect (int p, int o, mt_Node*n)
{
  insist (this);
  insist (!p);

  node = n;
  opposite = o;
  
  exception: return;
}
void mt_Host::disconnect (int p)
{
  insist (this);
  insist (!p);

  node = 0;
  opposite = -1;
  
  exception: return;
}

mt_Node*mt_Host::getNode (int p)
{
  insist (this);
  insist (!p);
  return node;
  exception: return 0;
}

int mt_Host::getOpposite (int p)
{
  insist (this);
  insist (!p);
  return opposite;
  exception: return -1;
}

int mt_Host::setOption (char*option, char*value)
{
  insist (this);
  insist (option && value);

  if (!mt_Node::setOption (option, value))
    return 1;
  
  if (!strcmp (option, "address"))
  {
    if (!address.fromString (value))
    {
      printFormat ("mm_Host::setOption: %s is not a valid myrinet address", value);
      return 0;
    }
  }
  else if (!strcmp (option, "gmId"))
  {
    gmId = atoi (value);
    if (gmId < 0)
    {
      printFormat ("mt_Host::setOption: %s is not a valid gmId", value);
      return 0;
    }
  }
  else if (!strcmp (option, "hostType"))
    hostType = atoi (value);
  
  return 1;
  exception: return 0;
}

int mt_Host::getGmId ()
{
  insist (this);
  return gmId;
  exception: return 0;
}

void mt_Host::setGmId (int gmId)
{
  insist (this);
  this->gmId = gmId;
  exception: return;
}

int mt_Host::getHostType ()
{
  insist (this);
  return hostType;
  exception: return 0;
}

mt_Address*mt_Host::getAddress ()
{
  insist (this);
  return &this->address;
  exception: return 0;
}

void mt_Host::setAddress (mt_Address*address)
{
  insist (this);
  insist (address);
  this->address = *address;
  exception: return;
}

