/*
  mt_Component.c
  map tools
  finucane@myri.com (David Finucane)
*/


#include <stdio.h>
#if GM_OS_VXWORKS
#include "vxWorks.h"
#endif /*GM_OS_VXWORKS */
#include <stdarg.h>
#include <time.h>
#include <stdlib.h>

#include "mt_Component.h"
#include "mt_Args.h"
#include "insist.h"

static mt_PrintLineFunction printLineFunction;;
int mt_Component::seed;

void mt_Component::initialize (mt_PrintLineFunction function)
{
  if (!function)
  {
    printf ("mt_Component::initialize: programer error. no printLineFunction\n");
  }
  printLineFunction = function;

  seed = 0;
}

int mt_Component::validComponent () const
{
  if (created != CREATED)
  {
    printInsist ("mt_Component::validComponent: programmer error. using uncreated object.");
  }
  
  if (destroyed)
  {
    printInsist ("mt_Component::validComponent: programmer error. using destroyed object.");
  }
  return 1;
}

mt_Component::~mt_Component()
{
  validComponent ();
  destroyed++;
}

mt_Component::mt_Component ()
{
  destroyed = 0;
  created = CREATED;
  
  if (!printLineFunction)
    printf ("Programmer error.\n" "mt_Component::initialize() not called.\n");
}


void mt_Component::printFormat (const char*fmt,...)
{
  if (!fmt || !printLineFunction)
    return;
  
  static char buffer [MAX_PRINTLINE];
  char*s = buffer;
  
  va_list args;
  va_start (args, fmt);
  vsprintf (s, fmt, args);
  va_end (args);
  
  (*printLineFunction) (buffer);
}

void mt_Component::printInsist (const char*fmt,...)
{
  if (!fmt || !printLineFunction)
    return;
  
  static char buffer [MAX_PRINTLINE];
  char*s = buffer;
  
  va_list args;
  va_start (args, fmt);
  vsprintf (s, fmt, args);
  va_end (args);
  
  (*printLineFunction) (buffer);
}

void mt_Component::srand (int seed)
{
  if (!mt_Component::seed)
  {
    if (!seed)
      seed = (int) time (0);  
    mt_Component::seed = seed;
    ::srand (mt_Component::seed);
  }
}

int mt_Component::rand (int afterMax)
{
  int a = (int) ((double) (((double) afterMax) - 0.0001) * (double) ::rand () / (double) RAND_MAX);
  insistf (a >= 0 && a < afterMax);
  return a;
  exception: return -1;
}
