/*
  mt_Args.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef mt_Args_h
#define mt_Args_h

#include "mt_Component.h"

class mt_Args : public mt_Component
{
  public:
  enum
  {
    MAX_ARGUMENT = 300,
    MAX_LINE = 2001
  };
  enum
  {  
    CALCULATOR = 0,
    SIMULATOR,
    SIMULATION,
    MAPPER,
    JOB,
    NUM_TYPES
  };

  private:
  int type;
  char *buffer;
  char**argv;
  int argc;
  int maxArgc;
  
  int argcs [NUM_TYPES];
  char**argvs [NUM_TYPES];
  int getNext (int offset, int argc, char**argv);
  int getType (char*s);
  int fromArgs (int argc, char**argv);
  int parse (char*filename, int*maxLength, char**argv, char*buffer);
  int fromFile (char*filename);
  
  public:
  mt_Args (int argc, char**argv);
  mt_Args (int type, int argc);
  ~mt_Args ();
  void addArg (char*s);
  void addArg (int n);
  static void usage ();
  char**getArgs (int type, int*argc) const;
};


#endif /*mt_Args_h*/






